/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

public class BigLongArray {
    private static final int DEFAULT_PAGE_SIZE = 4096;
    private final long[][] pages;
    public final int size;
    private final int pageSize;
    private final int pageCount;

    public BigLongArray(int size2) {
        this(size2, 4096);
    }

    public BigLongArray(int size2, int pageSize) {
        this.size = size2;
        this.pageSize = pageSize;
        int lastPageSize = size2 % pageSize;
        int fullPageCount = size2 / pageSize;
        this.pageCount = fullPageCount + (lastPageSize == 0 ? 0 : 1);
        this.pages = new long[this.pageCount][];
        for (int i2 = 0; i2 < fullPageCount; ++i2) {
            this.pages[i2] = new long[pageSize];
        }
        if (lastPageSize != 0) {
            this.pages[this.pages.length - 1] = new long[lastPageSize];
        }
    }

    public void set(int idx, long value2) {
        if (idx < 0 || idx > this.size) {
            throw new IndexOutOfBoundsException(String.format("%d is not whithin [0, %d)", idx, this.size));
        }
        int page = idx / this.pageSize;
        int pageIdx = idx % this.pageSize;
        this.pages[page][pageIdx] = value2;
    }

    public long get(int idx) {
        if (idx < 0 || idx > this.size) {
            throw new IndexOutOfBoundsException(String.format("%d is not whithin [0, %d)", idx, this.size));
        }
        int page = idx / this.pageSize;
        int pageIdx = idx % this.pageSize;
        return this.pages[page][pageIdx];
    }
}

