/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.jsr166e;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.elasticsearch.common.util.concurrent.jsr166e.CompletionException;
import org.elasticsearch.common.util.concurrent.jsr166e.ForkJoinPool;
import org.elasticsearch.common.util.concurrent.jsr166e.ForkJoinTask;
import org.elasticsearch.common.util.concurrent.jsr166y.ThreadLocalRandom;
import sun.misc.Unsafe;

public class CompletableFuture<T>
implements Future<T> {
    static final AltResult NIL = new AltResult(null);
    volatile Object result;
    volatile WaitNode waiters;
    volatile CompletionNode completions;
    static final int WAITING_GET_SPINS = 256;
    private static final Unsafe UNSAFE;
    private static final long RESULT;
    private static final long WAITERS;
    private static final long COMPLETIONS;

    final void postComplete() {
        CompletionNode h;
        WaitNode q;
        while ((q = this.waiters) != null) {
            Thread t;
            if (!UNSAFE.compareAndSwapObject(this, WAITERS, q, q.next) || (t = q.thread) == null) continue;
            q.thread = null;
            LockSupport.unpark(t);
        }
        while ((h = this.completions) != null) {
            Completion c;
            if (!UNSAFE.compareAndSwapObject(this, COMPLETIONS, h, h.next) || (c = h.completion) == null) continue;
            c.run();
        }
    }

    final void internalComplete(Object v, Throwable ex) {
        if (this.result == null) {
            UNSAFE.compareAndSwapObject(this, RESULT, null, ex == null ? (v == null ? NIL : v) : new AltResult(ex instanceof CompletionException ? ex : new CompletionException(ex)));
        }
        this.postComplete();
    }

    final void helpPostComplete() {
        if (this.result != null) {
            this.postComplete();
        }
    }

    private Object waitingGet(boolean interruptible) {
        WaitNode q = null;
        boolean queued = false;
        int h = 0;
        int spins = 0;
        while (true) {
            Object r;
            if ((r = this.result) != null) {
                if (q != null) {
                    q.thread = null;
                    if (q.interruptControl < 0) {
                        if (interruptible) {
                            this.removeWaiter(q);
                            return null;
                        }
                        Thread.currentThread().interrupt();
                    }
                }
                this.postComplete();
                return r;
            }
            if (h == 0) {
                h = ThreadLocalRandom.current().nextInt();
                if (Runtime.getRuntime().availableProcessors() <= 1) continue;
                spins = 256;
                continue;
            }
            if (spins > 0) {
                h ^= h << 1;
                h ^= h >>> 3;
                if ((h ^= h << 10) < 0) continue;
                --spins;
                continue;
            }
            if (q == null) {
                q = new WaitNode(interruptible, 0L, 0L);
                continue;
            }
            if (!queued) {
                q.next = this.waiters;
                queued = UNSAFE.compareAndSwapObject(this, WAITERS, q.next, q);
                continue;
            }
            if (interruptible && q.interruptControl < 0) {
                this.removeWaiter(q);
                return null;
            }
            if (q.thread == null || this.result != null) continue;
            try {
                ForkJoinPool.managedBlock(q);
                continue;
            }
            catch (InterruptedException ex) {
                q.interruptControl = -1;
                continue;
            }
            break;
        }
    }

    private Object timedAwaitDone(long nanos) throws InterruptedException, TimeoutException {
        WaitNode q = null;
        boolean queued = false;
        while (true) {
            Object r;
            if ((r = this.result) != null) {
                if (q != null) {
                    q.thread = null;
                    if (q.interruptControl < 0) {
                        this.removeWaiter(q);
                        throw new InterruptedException();
                    }
                }
                this.postComplete();
                return r;
            }
            if (q == null) {
                if (nanos <= 0L) {
                    throw new TimeoutException();
                }
                long d = System.nanoTime() + nanos;
                q = new WaitNode(true, nanos, d == 0L ? 1L : d);
                continue;
            }
            if (!queued) {
                q.next = this.waiters;
                queued = UNSAFE.compareAndSwapObject(this, WAITERS, q.next, q);
                continue;
            }
            if (q.interruptControl < 0) {
                this.removeWaiter(q);
                throw new InterruptedException();
            }
            if (q.nanos <= 0L) {
                if (this.result != null) continue;
                this.removeWaiter(q);
                throw new TimeoutException();
            }
            if (q.thread == null || this.result != null) continue;
            try {
                ForkJoinPool.managedBlock(q);
                continue;
            }
            catch (InterruptedException ex) {
                q.interruptControl = -1;
                continue;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(WaitNode node) {
        if (node != null) {
            node.thread = null;
            block0: while (true) {
                pred = null;
                q = this.waiters;
                while (q != null) {
                    s = q.next;
                    if (q.thread != null) {
                        pred = q;
                    } else if (pred != null) {
                        pred.next = s;
                        if (pred.thread == null) {
                            continue block0;
                        }
                    } else {
                        if (CompletableFuture.UNSAFE.compareAndSwapObject(this, CompletableFuture.WAITERS, q, s)) ** break;
                        continue block0;
                    }
                    q = s;
                }
                break;
            }
        }
    }

    public static <U> CompletableFuture<U> supplyAsync(Generator<U> supplier) {
        if (supplier == null) {
            throw new NullPointerException();
        }
        CompletableFuture f = new CompletableFuture();
        ForkJoinPool.commonPool().execute((ForkJoinTask<?>)new AsyncSupply<U>(supplier, f));
        return f;
    }

    public static <U> CompletableFuture<U> supplyAsync(Generator<U> supplier, Executor executor) {
        if (executor == null || supplier == null) {
            throw new NullPointerException();
        }
        CompletableFuture f = new CompletableFuture();
        executor.execute(new AsyncSupply<U>(supplier, f));
        return f;
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        ForkJoinPool.commonPool().execute(new AsyncRun(runnable, f));
        return f;
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable, Executor executor) {
        if (executor == null || runnable == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        executor.execute(new AsyncRun(runnable, f));
        return f;
    }

    @Override
    public boolean isDone() {
        return this.result != null;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        Throwable cause2;
        Object r = this.result;
        if (r == null && (r = this.waitingGet(true)) == null) {
            throw new InterruptedException();
        }
        if (!(r instanceof AltResult)) {
            Object tr2 = r;
            return (T)tr2;
        }
        Throwable ex = ((AltResult)r).ex;
        if (ex == null) {
            return null;
        }
        if (ex instanceof CancellationException) {
            throw (CancellationException)ex;
        }
        if (ex instanceof CompletionException && (cause2 = ex.getCause()) != null) {
            ex = cause2;
        }
        throw new ExecutionException(ex);
    }

    @Override
    public T get(long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Throwable cause2;
        long nanos = unit.toNanos(timeout2);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object r = this.result;
        if (r == null) {
            r = this.timedAwaitDone(nanos);
        }
        if (!(r instanceof AltResult)) {
            Object tr2 = r;
            return (T)tr2;
        }
        Throwable ex = ((AltResult)r).ex;
        if (ex == null) {
            return null;
        }
        if (ex instanceof CancellationException) {
            throw (CancellationException)ex;
        }
        if (ex instanceof CompletionException && (cause2 = ex.getCause()) != null) {
            ex = cause2;
        }
        throw new ExecutionException(ex);
    }

    public T join() {
        Object r = this.result;
        if (r == null) {
            r = this.waitingGet(false);
        }
        if (!(r instanceof AltResult)) {
            Object tr2 = r;
            return (T)tr2;
        }
        Throwable ex = ((AltResult)r).ex;
        if (ex == null) {
            return null;
        }
        if (ex instanceof CancellationException) {
            throw (CancellationException)ex;
        }
        if (ex instanceof CompletionException) {
            throw (CompletionException)ex;
        }
        throw new CompletionException(ex);
    }

    public T getNow(T valueIfAbsent) {
        Object r = this.result;
        if (r == null) {
            return valueIfAbsent;
        }
        if (!(r instanceof AltResult)) {
            Object tr2 = r;
            return (T)tr2;
        }
        Throwable ex = ((AltResult)r).ex;
        if (ex == null) {
            return null;
        }
        if (ex instanceof CancellationException) {
            throw (CancellationException)ex;
        }
        if (ex instanceof CompletionException) {
            throw (CompletionException)ex;
        }
        throw new CompletionException(ex);
    }

    public boolean complete(T value2) {
        boolean triggered = this.result == null && UNSAFE.compareAndSwapObject(this, RESULT, null, value2 == null ? NIL : value2);
        this.postComplete();
        return triggered;
    }

    public boolean completeExceptionally(Throwable ex) {
        if (ex == null) {
            throw new NullPointerException();
        }
        boolean triggered = this.result == null && UNSAFE.compareAndSwapObject(this, RESULT, null, new AltResult(ex));
        this.postComplete();
        return triggered;
    }

    public <U> CompletableFuture<U> thenApply(Fun<? super T, ? extends U> fn) {
        return this.doThenApply(fn, null);
    }

    public <U> CompletableFuture<U> thenApplyAsync(Fun<? super T, ? extends U> fn) {
        return this.doThenApply(fn, ForkJoinPool.commonPool());
    }

    public <U> CompletableFuture<U> thenApplyAsync(Fun<? super T, ? extends U> fn, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenApply(fn, executor);
    }

    private <U> CompletableFuture<U> doThenApply(Fun<? super T, ? extends U> fn, Executor e) {
        if (fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<T> dst = new CompletableFuture<T>();
        ApplyCompletion<T, U> d = null;
        Object r = this.result;
        if (r == null) {
            d = new ApplyCompletion<T, U>(this, fn, dst, e);
            CompletionNode p2 = new CompletionNode(d);
            while ((r = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p2.next = this.completions, p2)) {
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr2;
                ex = null;
                t = tr2 = r;
            }
            Object u = null;
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncApply<T, U>(t, fn, dst));
                    } else {
                        u = fn.apply(t);
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(u, ex);
            }
        }
        this.helpPostComplete();
        return dst;
    }

    public CompletableFuture<Void> thenAccept(Action<? super T> block) {
        return this.doThenAccept(block, null);
    }

    public CompletableFuture<Void> thenAcceptAsync(Action<? super T> block) {
        return this.doThenAccept(block, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> thenAcceptAsync(Action<? super T> block, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenAccept(block, executor);
    }

    private CompletableFuture<Void> doThenAccept(Action<? super T> fn, Executor e) {
        if (fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        AcceptCompletion<T> d = null;
        Object r = this.result;
        if (r == null) {
            d = new AcceptCompletion<T>(this, fn, dst, e);
            CompletionNode p2 = new CompletionNode(d);
            while ((r = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p2.next = this.completions, p2)) {
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr2;
                ex = null;
                t = tr2 = r;
            }
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncAccept<T>(t, fn, dst));
                    } else {
                        fn.accept(t);
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        return dst;
    }

    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.doThenRun(action, null);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return this.doThenRun(action, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenRun(action, executor);
    }

    private CompletableFuture<Void> doThenRun(Runnable action, Executor e) {
        if (action == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        RunCompletion d = null;
        Object r = this.result;
        if (r == null) {
            d = new RunCompletion(this, action, dst, e);
            CompletionNode p2 = new CompletionNode(d);
            while ((r = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p2.next = this.completions, p2)) {
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncRun(action, dst));
                    } else {
                        action.run();
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        return dst;
    }

    public <U, V> CompletableFuture<V> thenCombine(CompletableFuture<? extends U> other, BiFun<? super T, ? super U, ? extends V> fn) {
        return this.doThenBiApply(other, fn, null);
    }

    public <U, V> CompletableFuture<V> thenCombineAsync(CompletableFuture<? extends U> other, BiFun<? super T, ? super U, ? extends V> fn) {
        return this.doThenBiApply(other, fn, ForkJoinPool.commonPool());
    }

    public <U, V> CompletableFuture<V> thenCombineAsync(CompletableFuture<? extends U> other, BiFun<? super T, ? super U, ? extends V> fn, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenBiApply(other, fn, executor);
    }

    private <U, V> CompletableFuture<V> doThenBiApply(CompletableFuture<? extends U> other, BiFun<? super T, ? super U, ? extends V> fn, Executor e) {
        if (other == null || fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<T> dst = new CompletableFuture<T>();
        BiApplyCompletion<T, U, V> d = null;
        Object s2 = null;
        Object r = this.result;
        if (r == null || (s2 = other.result) == null) {
            d = new BiApplyCompletion<T, U, V>(this, other, fn, dst, e);
            CompletionNode q = null;
            CompletionNode p2 = new CompletionNode(d);
            while (r == null && (r = this.result) == null || s2 == null && (s2 = other.result) == null) {
                if (q != null) {
                    if (s2 == null && !UNSAFE.compareAndSwapObject(other, COMPLETIONS, q.next = other.completions, q)) continue;
                    break;
                }
                if (r == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p2.next = this.completions, p2)) continue;
                if (s2 != null) break;
                q = new CompletionNode(d);
            }
        }
        if (r != null && s2 != null && (d == null || d.compareAndSet(0, 1))) {
            Object u;
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr2;
                ex = null;
                t = tr2 = r;
            }
            if (ex != null) {
                u = null;
            } else if (s2 instanceof AltResult) {
                ex = ((AltResult)s2).ex;
                u = null;
            } else {
                Object us;
                u = us = s2;
            }
            Object v = null;
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncBiApply<T, U, V>(t, u, fn, dst));
                    } else {
                        v = fn.apply(t, u);
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(v, ex);
            }
        }
        this.helpPostComplete();
        other.helpPostComplete();
        return dst;
    }

    public <U> CompletableFuture<Void> thenAcceptBoth(CompletableFuture<? extends U> other, BiAction<? super T, ? super U> block) {
        return this.doThenBiAccept(other, block, null);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletableFuture<? extends U> other, BiAction<? super T, ? super U> block) {
        return this.doThenBiAccept(other, block, ForkJoinPool.commonPool());
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletableFuture<? extends U> other, BiAction<? super T, ? super U> block, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenBiAccept(other, block, executor);
    }

    private <U> CompletableFuture<Void> doThenBiAccept(CompletableFuture<? extends U> other, BiAction<? super T, ? super U> fn, Executor e) {
        if (other == null || fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        BiAcceptCompletion<T, U> d = null;
        Object s2 = null;
        Object r = this.result;
        if (r == null || (s2 = other.result) == null) {
            d = new BiAcceptCompletion<T, U>(this, other, fn, dst, e);
            CompletionNode q = null;
            CompletionNode p2 = new CompletionNode(d);
            while (r == null && (r = this.result) == null || s2 == null && (s2 = other.result) == null) {
                if (q != null) {
                    if (s2 == null && !UNSAFE.compareAndSwapObject(other, COMPLETIONS, q.next = other.completions, q)) continue;
                    break;
                }
                if (r == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p2.next = this.completions, p2)) continue;
                if (s2 != null) break;
                q = new CompletionNode(d);
            }
        }
        if (r != null && s2 != null && (d == null || d.compareAndSet(0, 1))) {
            Object u;
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr2;
                ex = null;
                t = tr2 = r;
            }
            if (ex != null) {
                u = null;
            } else if (s2 instanceof AltResult) {
                ex = ((AltResult)s2).ex;
                u = null;
            } else {
                Object us;
                u = us = s2;
            }
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncBiAccept<T, U>(t, u, fn, dst));
                    } else {
                        fn.accept(t, u);
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        other.helpPostComplete();
        return dst;
    }

    public CompletableFuture<Void> runAfterBoth(CompletableFuture<?> other, Runnable action) {
        return this.doThenBiRun(other, action, null);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletableFuture<?> other, Runnable action) {
        return this.doThenBiRun(other, action, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletableFuture<?> other, Runnable action, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doThenBiRun(other, action, executor);
    }

    private CompletableFuture<Void> doThenBiRun(CompletableFuture<?> other, Runnable action, Executor e) {
        if (other == null || action == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        BiRunCompletion d = null;
        Object s2 = null;
        Object r = this.result;
        if (r == null || (s2 = other.result) == null) {
            d = new BiRunCompletion(this, other, action, dst, e);
            CompletionNode q = null;
            CompletionNode p2 = new CompletionNode(d);
            while (r == null && (r = this.result) == null || s2 == null && (s2 = other.result) == null) {
                if (q != null) {
                    if (s2 == null && !UNSAFE.compareAndSwapObject(other, COMPLETIONS, q.next = other.completions, q)) continue;
                    break;
                }
                if (r == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p2.next = this.completions, p2)) continue;
                if (s2 != null) break;
                q = new CompletionNode(d);
            }
        }
        if (r != null && s2 != null && (d == null || d.compareAndSet(0, 1))) {
            Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
            if (ex == null && s2 instanceof AltResult) {
                ex = ((AltResult)s2).ex;
            }
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncRun(action, dst));
                    } else {
                        action.run();
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        other.helpPostComplete();
        return dst;
    }

    public <U> CompletableFuture<U> applyToEither(CompletableFuture<? extends T> other, Fun<? super T, U> fn) {
        return this.doOrApply(other, fn, null);
    }

    public <U> CompletableFuture<U> applyToEitherAsync(CompletableFuture<? extends T> other, Fun<? super T, U> fn) {
        return this.doOrApply(other, fn, ForkJoinPool.commonPool());
    }

    public <U> CompletableFuture<U> applyToEitherAsync(CompletableFuture<? extends T> other, Fun<? super T, U> fn, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doOrApply(other, fn, executor);
    }

    private <U> CompletableFuture<U> doOrApply(CompletableFuture<? extends T> other, Fun<? super T, U> fn, Executor e) {
        if (other == null || fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<T> dst = new CompletableFuture<T>();
        OrApplyCompletion<T, U> d = null;
        Object r = this.result;
        if (r == null && (r = other.result) == null) {
            d = new OrApplyCompletion<T, U>(this, other, fn, dst, e);
            CompletionNode q = null;
            CompletionNode p2 = new CompletionNode(d);
            while ((r = this.result) == null && (r = other.result) == null) {
                if (q != null) {
                    q.next = other.completions;
                    if (!UNSAFE.compareAndSwapObject(other, COMPLETIONS, q.next, q)) continue;
                    break;
                }
                p2.next = this.completions;
                if (!UNSAFE.compareAndSwapObject(this, COMPLETIONS, p2.next, p2)) continue;
                q = new CompletionNode(d);
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr2;
                ex = null;
                t = tr2 = r;
            }
            Object u = null;
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncApply<T, U>(t, fn, dst));
                    } else {
                        u = fn.apply(t);
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(u, ex);
            }
        }
        this.helpPostComplete();
        other.helpPostComplete();
        return dst;
    }

    public CompletableFuture<Void> acceptEither(CompletableFuture<? extends T> other, Action<? super T> block) {
        return this.doOrAccept(other, block, null);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletableFuture<? extends T> other, Action<? super T> block) {
        return this.doOrAccept(other, block, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletableFuture<? extends T> other, Action<? super T> block, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doOrAccept(other, block, executor);
    }

    private CompletableFuture<Void> doOrAccept(CompletableFuture<? extends T> other, Action<? super T> fn, Executor e) {
        if (other == null || fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        OrAcceptCompletion<T> d = null;
        Object r = this.result;
        if (r == null && (r = other.result) == null) {
            d = new OrAcceptCompletion<T>(this, other, fn, dst, e);
            CompletionNode q = null;
            CompletionNode p2 = new CompletionNode(d);
            while ((r = this.result) == null && (r = other.result) == null) {
                if (q != null) {
                    q.next = other.completions;
                    if (!UNSAFE.compareAndSwapObject(other, COMPLETIONS, q.next, q)) continue;
                    break;
                }
                p2.next = this.completions;
                if (!UNSAFE.compareAndSwapObject(this, COMPLETIONS, p2.next, p2)) continue;
                q = new CompletionNode(d);
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr2;
                ex = null;
                t = tr2 = r;
            }
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncAccept<T>(t, fn, dst));
                    } else {
                        fn.accept(t);
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        other.helpPostComplete();
        return dst;
    }

    public CompletableFuture<Void> runAfterEither(CompletableFuture<?> other, Runnable action) {
        return this.doOrRun(other, action, null);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletableFuture<?> other, Runnable action) {
        return this.doOrRun(other, action, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletableFuture<?> other, Runnable action, Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        return this.doOrRun(other, action, executor);
    }

    private CompletableFuture<Void> doOrRun(CompletableFuture<?> other, Runnable action, Executor e) {
        if (other == null || action == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> dst = new CompletableFuture<Void>();
        OrRunCompletion d = null;
        Object r = this.result;
        if (r == null && (r = other.result) == null) {
            d = new OrRunCompletion(this, other, action, dst, e);
            CompletionNode q = null;
            CompletionNode p2 = new CompletionNode(d);
            while ((r = this.result) == null && (r = other.result) == null) {
                if (q != null) {
                    q.next = other.completions;
                    if (!UNSAFE.compareAndSwapObject(other, COMPLETIONS, q.next, q)) continue;
                    break;
                }
                p2.next = this.completions;
                if (!UNSAFE.compareAndSwapObject(this, COMPLETIONS, p2.next, p2)) continue;
                q = new CompletionNode(d);
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
            if (ex == null) {
                try {
                    if (e != null) {
                        e.execute(new AsyncRun(action, dst));
                    } else {
                        action.run();
                    }
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (e == null || ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        other.helpPostComplete();
        return dst;
    }

    public <U> CompletableFuture<U> thenCompose(Fun<? super T, CompletableFuture<U>> fn) {
        if (fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Object> dst = null;
        ComposeCompletion<T, U> d = null;
        Object r = this.result;
        if (r == null) {
            dst = new CompletableFuture<T>();
            d = new ComposeCompletion<T, U>(this, fn, dst);
            CompletionNode p2 = new CompletionNode(d);
            while ((r = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p2.next = this.completions, p2)) {
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr2;
                ex = null;
                t = tr2 = r;
            }
            if (ex == null) {
                try {
                    dst = fn.apply(t);
                }
                catch (Throwable rex) {
                    ex = rex;
                }
            }
            if (dst == null) {
                dst = new CompletableFuture<T>();
                if (ex == null) {
                    ex = new NullPointerException();
                }
            }
            if (ex != null) {
                dst.internalComplete(null, ex);
            }
        }
        this.helpPostComplete();
        dst.helpPostComplete();
        return dst;
    }

    public CompletableFuture<T> exceptionally(Fun<Throwable, ? extends T> fn) {
        if (fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<T> dst = new CompletableFuture<T>();
        ExceptionCompletion<T> d = null;
        Object r = this.result;
        if (r == null) {
            d = new ExceptionCompletion<T>(this, fn, dst);
            CompletionNode p2 = new CompletionNode(d);
            while ((r = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p2.next = this.completions, p2)) {
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Object t = null;
            Throwable dx = null;
            if (r instanceof AltResult) {
                Throwable ex = ((AltResult)r).ex;
                if (ex != null) {
                    try {
                        t = fn.apply(ex);
                    }
                    catch (Throwable rex) {
                        dx = rex;
                    }
                }
            } else {
                Object tr2;
                t = tr2 = r;
            }
            dst.internalComplete(t, dx);
        }
        this.helpPostComplete();
        return dst;
    }

    public <U> CompletableFuture<U> handle(BiFun<? super T, Throwable, ? extends U> fn) {
        if (fn == null) {
            throw new NullPointerException();
        }
        CompletableFuture<T> dst = new CompletableFuture<T>();
        HandleCompletion<T, U> d = null;
        Object r = this.result;
        if (r == null) {
            d = new HandleCompletion<T, U>(this, fn, dst);
            CompletionNode p2 = new CompletionNode(d);
            while ((r = this.result) == null && !UNSAFE.compareAndSwapObject(this, COMPLETIONS, p2.next = this.completions, p2)) {
            }
        }
        if (r != null && (d == null || d.compareAndSet(0, 1))) {
            Throwable dx;
            U u;
            Object t;
            Throwable ex;
            if (r instanceof AltResult) {
                ex = ((AltResult)r).ex;
                t = null;
            } else {
                Object tr2;
                ex = null;
                t = tr2 = r;
            }
            try {
                u = fn.apply(t, ex);
                dx = null;
            }
            catch (Throwable rex) {
                dx = rex;
                u = null;
            }
            dst.internalComplete(u, dx);
        }
        this.helpPostComplete();
        return dst;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object r;
        while ((r = this.result) == null) {
            r = new AltResult(new CancellationException());
            if (!UNSAFE.compareAndSwapObject(this, RESULT, null, r)) continue;
            this.postComplete();
            return true;
        }
        return r instanceof AltResult && ((AltResult)r).ex instanceof CancellationException;
    }

    @Override
    public boolean isCancelled() {
        Object r = this.result;
        return r instanceof AltResult && ((AltResult)r).ex instanceof CancellationException;
    }

    public void obtrudeValue(T value2) {
        this.result = value2 == null ? NIL : value2;
        this.postComplete();
    }

    public void obtrudeException(Throwable ex) {
        if (ex == null) {
            throw new NullPointerException();
        }
        this.result = new AltResult(ex);
        this.postComplete();
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException tryReflectionInstead) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : k.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static {
        try {
            UNSAFE = CompletableFuture.getUnsafe();
            Class<CompletableFuture> k = CompletableFuture.class;
            RESULT = UNSAFE.objectFieldOffset(k.getDeclaredField("result"));
            WAITERS = UNSAFE.objectFieldOffset(k.getDeclaredField("waiters"));
            COMPLETIONS = UNSAFE.objectFieldOffset(k.getDeclaredField("completions"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static final class ComposeCompletion<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Fun<? super T, CompletableFuture<U>> fn;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        ComposeCompletion(CompletableFuture<? extends T> src, Fun<? super T, CompletableFuture<U>> fn, CompletableFuture<U> dst) {
            this.src = src;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<? extends T> a;
            Fun<T, CompletableFuture<U>> fn;
            CompletableFuture<U> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr2;
                    ex = null;
                    t = tr2 = r;
                }
                CompletableFuture<U> c = null;
                Object u = null;
                boolean complete = false;
                if (ex == null) {
                    try {
                        c = fn.apply(t);
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (ex != null || c == null) {
                    if (ex == null) {
                        ex = new NullPointerException();
                    }
                } else {
                    ThenCopy<U> d = null;
                    Object s2 = c.result;
                    if (s2 == null) {
                        d = new ThenCopy<U>(c, dst);
                        CompletionNode p2 = new CompletionNode(d);
                        while ((s2 = c.result) == null) {
                            p2.next = c.completions;
                            if (!UNSAFE.compareAndSwapObject(c, COMPLETIONS, p2.next, p2)) continue;
                        }
                    }
                    if (s2 != null && (d == null || d.compareAndSet(0, 1))) {
                        complete = true;
                        if (s2 instanceof AltResult) {
                            ex = ((AltResult)s2).ex;
                            u = null;
                        } else {
                            Object us;
                            u = us = s2;
                        }
                    }
                }
                if (complete || ex != null) {
                    dst.internalComplete(u, ex);
                }
                if (c != null) {
                    c.helpPostComplete();
                }
            }
        }
    }

    static final class HandleCompletion<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final BiFun<? super T, Throwable, ? extends U> fn;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        HandleCompletion(CompletableFuture<? extends T> src, BiFun<? super T, Throwable, ? extends U> fn, CompletableFuture<U> dst) {
            this.src = src;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<? extends T> a;
            BiFun<T, Throwable, U> fn;
            CompletableFuture<U> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr2;
                    ex = null;
                    t = tr2 = r;
                }
                Object u = null;
                Throwable dx = null;
                try {
                    u = fn.apply(t, ex);
                }
                catch (Throwable rex) {
                    dx = rex;
                }
                dst.internalComplete(u, dx);
            }
        }
    }

    static final class ThenCopy<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<T> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        ThenCopy(CompletableFuture<? extends T> src, CompletableFuture<T> dst) {
            this.src = src;
            this.dst = dst;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<? extends T> a;
            CompletableFuture<T> dst = this.dst;
            if (dst != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    ex = null;
                    t = r;
                }
                dst.internalComplete(t, ex);
            }
        }
    }

    static final class ExceptionCompletion<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Fun<? super Throwable, ? extends T> fn;
        final CompletableFuture<T> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        ExceptionCompletion(CompletableFuture<? extends T> src, Fun<? super Throwable, ? extends T> fn, CompletableFuture<T> dst) {
            this.src = src;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<? extends T> a;
            Fun<Throwable, T> fn;
            Object t = null;
            Throwable dx = null;
            CompletableFuture<T> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Throwable ex;
                if (r instanceof AltResult && (ex = ((AltResult)r).ex) != null) {
                    try {
                        t = fn.apply(ex);
                    }
                    catch (Throwable rex) {
                        dx = rex;
                    }
                } else {
                    Object tr2;
                    t = tr2 = r;
                }
                dst.internalComplete(t, dx);
            }
        }
    }

    static final class OrRunCompletion<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<?> snd;
        final Runnable fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        OrRunCompletion(CompletableFuture<? extends T> src, CompletableFuture<?> snd, Runnable fn, CompletableFuture<Void> dst, Executor executor) {
            this.src = src;
            this.snd = snd;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            CompletableFuture<?> b;
            Object r;
            CompletableFuture<? extends T> a;
            Runnable fn;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && ((a = this.src) != null && (r = a.result) != null || (b = this.snd) != null && (r = b.result) != null) && this.compareAndSet(0, 1)) {
                Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
                Executor e = this.executor;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncRun(fn, dst));
                        } else {
                            fn.run();
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(null, ex);
                }
            }
        }
    }

    static final class OrAcceptCompletion<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends T> snd;
        final Action<? super T> fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        OrAcceptCompletion(CompletableFuture<? extends T> src, CompletableFuture<? extends T> snd, Action<? super T> fn, CompletableFuture<Void> dst, Executor executor) {
            this.src = src;
            this.snd = snd;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            CompletableFuture<? extends T> b;
            Object r;
            CompletableFuture<? extends T> a;
            Action<T> fn;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && ((a = this.src) != null && (r = a.result) != null || (b = this.snd) != null && (r = b.result) != null) && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr2;
                    ex = null;
                    t = tr2 = r;
                }
                Executor e = this.executor;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncAccept<T>(t, fn, dst));
                        } else {
                            fn.accept(t);
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(null, ex);
                }
            }
        }
    }

    static final class OrApplyCompletion<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends T> snd;
        final Fun<? super T, ? extends U> fn;
        final CompletableFuture<U> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        OrApplyCompletion(CompletableFuture<? extends T> src, CompletableFuture<? extends T> snd, Fun<? super T, ? extends U> fn, CompletableFuture<U> dst, Executor executor) {
            this.src = src;
            this.snd = snd;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            CompletableFuture<? extends T> b;
            Object r;
            CompletableFuture<? extends T> a;
            Fun<T, U> fn;
            CompletableFuture<U> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && ((a = this.src) != null && (r = a.result) != null || (b = this.snd) != null && (r = b.result) != null) && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr2;
                    ex = null;
                    t = tr2 = r;
                }
                Executor e = this.executor;
                Object u = null;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncApply<T, U>(t, fn, dst));
                        } else {
                            u = fn.apply(t);
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(u, ex);
                }
            }
        }
    }

    static final class BiRunCompletion<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<?> snd;
        final Runnable fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        BiRunCompletion(CompletableFuture<? extends T> src, CompletableFuture<?> snd, Runnable fn, CompletableFuture<Void> dst, Executor executor) {
            this.src = src;
            this.snd = snd;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object s2;
            CompletableFuture<?> b;
            Object r;
            CompletableFuture<? extends T> a;
            Runnable fn;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && (b = this.snd) != null && (s2 = b.result) != null && this.compareAndSet(0, 1)) {
                Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
                if (ex == null && s2 instanceof AltResult) {
                    ex = ((AltResult)s2).ex;
                }
                Executor e = this.executor;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncRun(fn, dst));
                        } else {
                            fn.run();
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(null, ex);
                }
            }
        }
    }

    static final class BiAcceptCompletion<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends U> snd;
        final BiAction<? super T, ? super U> fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        BiAcceptCompletion(CompletableFuture<? extends T> src, CompletableFuture<? extends U> snd, BiAction<? super T, ? super U> fn, CompletableFuture<Void> dst, Executor executor) {
            this.src = src;
            this.snd = snd;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object s2;
            CompletableFuture<? extends U> b;
            Object r;
            CompletableFuture<? extends T> a;
            BiAction<T, U> fn;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && (b = this.snd) != null && (s2 = b.result) != null && this.compareAndSet(0, 1)) {
                Object u;
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr2;
                    ex = null;
                    t = tr2 = r;
                }
                if (ex != null) {
                    u = null;
                } else if (s2 instanceof AltResult) {
                    ex = ((AltResult)s2).ex;
                    u = null;
                } else {
                    Object us;
                    u = us = s2;
                }
                Executor e = this.executor;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncBiAccept<T, U>(t, u, fn, dst));
                        } else {
                            fn.accept(t, u);
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(null, ex);
                }
            }
        }
    }

    static final class BiApplyCompletion<T, U, V>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final CompletableFuture<? extends U> snd;
        final BiFun<? super T, ? super U, ? extends V> fn;
        final CompletableFuture<V> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        BiApplyCompletion(CompletableFuture<? extends T> src, CompletableFuture<? extends U> snd, BiFun<? super T, ? super U, ? extends V> fn, CompletableFuture<V> dst, Executor executor) {
            this.src = src;
            this.snd = snd;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object s2;
            CompletableFuture<? extends U> b;
            Object r;
            CompletableFuture<? extends T> a;
            BiFun<T, U, V> fn;
            CompletableFuture<V> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && (b = this.snd) != null && (s2 = b.result) != null && this.compareAndSet(0, 1)) {
                Object u;
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr2;
                    ex = null;
                    t = tr2 = r;
                }
                if (ex != null) {
                    u = null;
                } else if (s2 instanceof AltResult) {
                    ex = ((AltResult)s2).ex;
                    u = null;
                } else {
                    Object us;
                    u = us = s2;
                }
                Executor e = this.executor;
                Object v = null;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncBiApply<T, U, V>(t, u, fn, dst));
                        } else {
                            v = fn.apply(t, u);
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(v, ex);
                }
            }
        }
    }

    static final class RunCompletion<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Runnable fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        RunCompletion(CompletableFuture<? extends T> src, Runnable fn, CompletableFuture<Void> dst, Executor executor) {
            this.src = src;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<? extends T> a;
            Runnable fn;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Throwable ex = r instanceof AltResult ? ((AltResult)r).ex : null;
                Executor e = this.executor;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncRun(fn, dst));
                        } else {
                            fn.run();
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(null, ex);
                }
            }
        }
    }

    static final class AcceptCompletion<T>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Action<? super T> fn;
        final CompletableFuture<Void> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        AcceptCompletion(CompletableFuture<? extends T> src, Action<? super T> fn, CompletableFuture<Void> dst, Executor executor) {
            this.src = src;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<? extends T> a;
            Action<T> fn;
            CompletableFuture<Void> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr2;
                    ex = null;
                    t = tr2 = r;
                }
                Executor e = this.executor;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncAccept<T>(t, fn, dst));
                        } else {
                            fn.accept(t);
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(null, ex);
                }
            }
        }
    }

    static final class ApplyCompletion<T, U>
    extends Completion {
        final CompletableFuture<? extends T> src;
        final Fun<? super T, ? extends U> fn;
        final CompletableFuture<U> dst;
        final Executor executor;
        private static final long serialVersionUID = 5232453952276885070L;

        ApplyCompletion(CompletableFuture<? extends T> src, Fun<? super T, ? extends U> fn, CompletableFuture<U> dst, Executor executor) {
            this.src = src;
            this.fn = fn;
            this.dst = dst;
            this.executor = executor;
        }

        @Override
        public final void run() {
            Object r;
            CompletableFuture<? extends T> a;
            Fun<T, U> fn;
            CompletableFuture<U> dst = this.dst;
            if (dst != null && (fn = this.fn) != null && (a = this.src) != null && (r = a.result) != null && this.compareAndSet(0, 1)) {
                Object t;
                Throwable ex;
                if (r instanceof AltResult) {
                    ex = ((AltResult)r).ex;
                    t = null;
                } else {
                    Object tr2;
                    ex = null;
                    t = tr2 = r;
                }
                Executor e = this.executor;
                Object u = null;
                if (ex == null) {
                    try {
                        if (e != null) {
                            e.execute(new AsyncApply<T, U>(t, fn, dst));
                        } else {
                            u = fn.apply(t);
                        }
                    }
                    catch (Throwable rex) {
                        ex = rex;
                    }
                }
                if (e == null || ex != null) {
                    dst.internalComplete(u, ex);
                }
            }
        }
    }

    static abstract class Completion
    extends AtomicInteger
    implements Runnable {
        Completion() {
        }
    }

    static final class CompletionNode {
        final Completion completion;
        volatile CompletionNode next;

        CompletionNode(Completion completion) {
            this.completion = completion;
        }
    }

    static final class AsyncBiAccept<T, U>
    extends Async {
        final BiAction<? super T, ? super U> fn;
        final T arg1;
        final U arg2;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncBiAccept(T arg1, U arg2, BiAction<? super T, ? super U> fn, CompletableFuture<Void> dst) {
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<Void> d = this.dst;
            if (d != null && d.result == null) {
                Throwable ex;
                try {
                    this.fn.accept(this.arg1, this.arg2);
                    ex = null;
                }
                catch (Throwable rex) {
                    ex = rex;
                }
                d.internalComplete(null, ex);
            }
            return true;
        }
    }

    static final class AsyncAccept<T>
    extends Async {
        final Action<? super T> fn;
        final T arg;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncAccept(T arg2, Action<? super T> fn, CompletableFuture<Void> dst) {
            this.arg = arg2;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<Void> d = this.dst;
            if (d != null && d.result == null) {
                Throwable ex;
                try {
                    this.fn.accept(this.arg);
                    ex = null;
                }
                catch (Throwable rex) {
                    ex = rex;
                }
                d.internalComplete(null, ex);
            }
            return true;
        }
    }

    static final class AsyncBiApply<T, U, V>
    extends Async {
        final BiFun<? super T, ? super U, ? extends V> fn;
        final T arg1;
        final U arg2;
        final CompletableFuture<V> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncBiApply(T arg1, U arg2, BiFun<? super T, ? super U, ? extends V> fn, CompletableFuture<V> dst) {
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<V> d = this.dst;
            if (d != null && d.result == null) {
                Throwable ex;
                Object v;
                try {
                    v = this.fn.apply(this.arg1, this.arg2);
                    ex = null;
                }
                catch (Throwable rex) {
                    ex = rex;
                    v = null;
                }
                d.internalComplete(v, ex);
            }
            return true;
        }
    }

    static final class AsyncApply<T, U>
    extends Async {
        final Fun<? super T, ? extends U> fn;
        final T arg;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncApply(T arg2, Fun<? super T, ? extends U> fn, CompletableFuture<U> dst) {
            this.arg = arg2;
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<U> d = this.dst;
            if (d != null && d.result == null) {
                Throwable ex;
                U u;
                try {
                    u = this.fn.apply(this.arg);
                    ex = null;
                }
                catch (Throwable rex) {
                    ex = rex;
                    u = null;
                }
                d.internalComplete(u, ex);
            }
            return true;
        }
    }

    static final class AsyncSupply<U>
    extends Async {
        final Generator<U> fn;
        final CompletableFuture<U> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncSupply(Generator<U> fn, CompletableFuture<U> dst) {
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<U> d = this.dst;
            if (d != null && d.result == null) {
                Throwable ex;
                U u;
                try {
                    u = this.fn.get();
                    ex = null;
                }
                catch (Throwable rex) {
                    ex = rex;
                    u = null;
                }
                d.internalComplete(u, ex);
            }
            return true;
        }
    }

    static final class AsyncRun
    extends Async {
        final Runnable fn;
        final CompletableFuture<Void> dst;
        private static final long serialVersionUID = 5232453952276885070L;

        AsyncRun(Runnable fn, CompletableFuture<Void> dst) {
            this.fn = fn;
            this.dst = dst;
        }

        @Override
        public final boolean exec() {
            CompletableFuture<Void> d = this.dst;
            if (d != null && d.result == null) {
                Throwable ex;
                try {
                    this.fn.run();
                    ex = null;
                }
                catch (Throwable rex) {
                    ex = rex;
                }
                d.internalComplete(null, ex);
            }
            return true;
        }
    }

    static abstract class Async
    extends ForkJoinTask<Void>
    implements Runnable,
    AsynchronousCompletionTask {
        Async() {
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void v) {
        }

        @Override
        public final void run() {
            this.exec();
        }
    }

    public static interface AsynchronousCompletionTask {
    }

    static final class WaitNode
    implements ForkJoinPool.ManagedBlocker {
        long nanos;
        final long deadline;
        volatile int interruptControl;
        volatile Thread thread = Thread.currentThread();
        volatile WaitNode next;

        WaitNode(boolean interruptible, long nanos, long deadline) {
            this.interruptControl = interruptible ? 1 : 0;
            this.nanos = nanos;
            this.deadline = deadline;
        }

        @Override
        public boolean isReleasable() {
            if (this.thread == null) {
                return true;
            }
            if (Thread.interrupted()) {
                int i2 = this.interruptControl;
                this.interruptControl = -1;
                if (i2 > 0) {
                    return true;
                }
            }
            if (this.deadline != 0L && (this.nanos <= 0L || (this.nanos = this.deadline - System.nanoTime()) <= 0L)) {
                this.thread = null;
                return true;
            }
            return false;
        }

        @Override
        public boolean block() {
            if (this.isReleasable()) {
                return true;
            }
            if (this.deadline == 0L) {
                LockSupport.park(this);
            } else if (this.nanos > 0L) {
                LockSupport.parkNanos(this, this.nanos);
            }
            return this.isReleasable();
        }
    }

    static final class AltResult {
        final Throwable ex;

        AltResult(Throwable ex) {
            this.ex = ex;
        }
    }

    public static interface Generator<T> {
        public T get();
    }

    public static interface BiFun<A, B, T> {
        public T apply(A var1, B var2);
    }

    public static interface Fun<A, T> {
        public T apply(A var1);
    }

    public static interface BiAction<A, B> {
        public void accept(A var1, B var2);
    }

    public static interface Action<A> {
        public void accept(A var1);
    }
}

