/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.xcontent.XContentBuilder;

public interface ToXContent {
    public static final Params EMPTY_PARAMS = new Params(){

        @Override
        public String param(String key2) {
            return null;
        }

        @Override
        public String param(String key2, String defaultValue) {
            return defaultValue;
        }

        @Override
        public boolean paramAsBoolean(String key2, boolean defaultValue) {
            return defaultValue;
        }

        @Override
        public Boolean paramAsBooleanOptional(String key2, Boolean defaultValue) {
            return defaultValue;
        }
    };

    public XContentBuilder toXContent(XContentBuilder var1, Params var2) throws IOException;

    public static class MapParams
    implements Params {
        private final Map<String, String> params;

        public MapParams(Map<String, String> params2) {
            this.params = params2;
        }

        @Override
        public String param(String key2) {
            return this.params.get(key2);
        }

        @Override
        public String param(String key2, String defaultValue) {
            String value2 = this.params.get(key2);
            if (value2 == null) {
                return defaultValue;
            }
            return value2;
        }

        @Override
        public boolean paramAsBoolean(String key2, boolean defaultValue) {
            return Booleans.parseBoolean(this.param(key2), defaultValue);
        }

        @Override
        public Boolean paramAsBooleanOptional(String key2, Boolean defaultValue) {
            String sValue = this.param(key2);
            if (sValue == null) {
                return defaultValue;
            }
            return !sValue.equals("false") && !sValue.equals("0") && !sValue.equals("off");
        }
    }

    public static interface Params {
        public String param(String var1);

        public String param(String var1, String var2);

        public boolean paramAsBoolean(String var1, boolean var2);

        public Boolean paramAsBooleanOptional(String var1, Boolean var2);
    }
}

