/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.smile.SmileXContent;
import org.elasticsearch.common.xcontent.yaml.YamlXContent;

public enum XContentType {
    JSON(0){

        @Override
        public String restContentType() {
            return "application/json; charset=UTF-8";
        }

        @Override
        public String shortName() {
            return "json";
        }

        @Override
        public XContent xContent() {
            return JsonXContent.jsonXContent;
        }
    }
    ,
    SMILE(1){

        @Override
        public String restContentType() {
            return "application/smile";
        }

        @Override
        public String shortName() {
            return "smile";
        }

        @Override
        public XContent xContent() {
            return SmileXContent.smileXContent;
        }
    }
    ,
    YAML(2){

        @Override
        public String restContentType() {
            return "application/yaml";
        }

        @Override
        public String shortName() {
            return "yaml";
        }

        @Override
        public XContent xContent() {
            return YamlXContent.yamlXContent;
        }
    };

    private int index;

    public static XContentType fromRestContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        if ("application/json".equals(contentType) || "json".equalsIgnoreCase(contentType)) {
            return JSON;
        }
        if ("application/smile".equals(contentType) || "smile".equalsIgnoreCase(contentType)) {
            return SMILE;
        }
        if ("application/yaml".equals(contentType) || "yaml".equalsIgnoreCase(contentType)) {
            return YAML;
        }
        return null;
    }

    private XContentType(int index2) {
        this.index = index2;
    }

    public int index() {
        return this.index;
    }

    public abstract String restContentType();

    public abstract String shortName();

    public abstract XContent xContent();
}

