/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;

public class XContentMapConverter {
    public static final MapFactory SIMPLE_MAP_FACTORY = new MapFactory(){

        @Override
        public Map<String, Object> newMap() {
            return new HashMap<String, Object>();
        }
    };
    public static final MapFactory ORDERED_MAP_FACTORY = new MapFactory(){

        @Override
        public Map<String, Object> newMap() {
            return new LinkedHashMap<String, Object>();
        }
    };

    public static Map<String, Object> readMap(XContentParser parser) throws IOException {
        return XContentMapConverter.readMap(parser, SIMPLE_MAP_FACTORY);
    }

    public static Map<String, Object> readOrderedMap(XContentParser parser) throws IOException {
        return XContentMapConverter.readMap(parser, ORDERED_MAP_FACTORY);
    }

    public static Map<String, Object> readMap(XContentParser parser, MapFactory mapFactory) throws IOException {
        Map<String, Object> map = mapFactory.newMap();
        XContentParser.Token t = parser.currentToken();
        if (t == null) {
            t = parser.nextToken();
        }
        if (t == XContentParser.Token.START_OBJECT) {
            t = parser.nextToken();
        }
        while (t == XContentParser.Token.FIELD_NAME) {
            String fieldName = parser.currentName();
            t = parser.nextToken();
            Object value2 = XContentMapConverter.readValue(parser, mapFactory, t);
            map.put(fieldName, value2);
            t = parser.nextToken();
        }
        return map;
    }

    private static List<Object> readList(XContentParser parser, MapFactory mapFactory, XContentParser.Token t) throws IOException {
        ArrayList<Object> list2 = new ArrayList<Object>();
        while ((t = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            list2.add(XContentMapConverter.readValue(parser, mapFactory, t));
        }
        return list2;
    }

    private static Object readValue(XContentParser parser, MapFactory mapFactory, XContentParser.Token t) throws IOException {
        if (t == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (t == XContentParser.Token.VALUE_STRING) {
            return parser.text();
        }
        if (t == XContentParser.Token.VALUE_NUMBER) {
            XContentParser.NumberType numberType = parser.numberType();
            if (numberType == XContentParser.NumberType.INT) {
                return parser.intValue();
            }
            if (numberType == XContentParser.NumberType.LONG) {
                return parser.longValue();
            }
            if (numberType == XContentParser.NumberType.FLOAT) {
                return Float.valueOf(parser.floatValue());
            }
            if (numberType == XContentParser.NumberType.DOUBLE) {
                return parser.doubleValue();
            }
        } else {
            if (t == XContentParser.Token.VALUE_BOOLEAN) {
                return parser.booleanValue();
            }
            if (t == XContentParser.Token.START_OBJECT) {
                return XContentMapConverter.readMap(parser, mapFactory);
            }
            if (t == XContentParser.Token.START_ARRAY) {
                return XContentMapConverter.readList(parser, mapFactory, t);
            }
            if (t == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                return parser.binaryValue();
            }
        }
        return null;
    }

    public static void writeMap(XContentGenerator gen, Map<String, Object> map) throws IOException {
        gen.writeStartObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            gen.writeFieldName(entry.getKey());
            Object value2 = entry.getValue();
            if (value2 == null) {
                gen.writeNull();
                continue;
            }
            XContentMapConverter.writeValue(gen, value2);
        }
        gen.writeEndObject();
    }

    private static void writeIterable(XContentGenerator gen, Iterable iterable) throws IOException {
        gen.writeStartArray();
        for (Object value2 : iterable) {
            XContentMapConverter.writeValue(gen, value2);
        }
        gen.writeEndArray();
    }

    private static void writeObjectArray(XContentGenerator gen, Object[] array) throws IOException {
        gen.writeStartArray();
        for (Object value2 : array) {
            XContentMapConverter.writeValue(gen, value2);
        }
        gen.writeEndArray();
    }

    private static void writeValue(XContentGenerator gen, Object value2) throws IOException {
        if (value2 == null) {
            gen.writeNull();
            return;
        }
        Class<?> type2 = value2.getClass();
        if (type2 == String.class) {
            gen.writeString((String)value2);
        } else if (type2 == Integer.class) {
            gen.writeNumber((Integer)value2);
        } else if (type2 == Long.class) {
            gen.writeNumber((Long)value2);
        } else if (type2 == Float.class) {
            gen.writeNumber(((Float)value2).floatValue());
        } else if (type2 == Double.class) {
            gen.writeNumber((Double)value2);
        } else if (type2 == Short.class) {
            gen.writeNumber(((Short)value2).shortValue());
        } else if (type2 == Boolean.class) {
            gen.writeBoolean((Boolean)value2);
        } else if (value2 instanceof Map) {
            XContentMapConverter.writeMap(gen, (Map)value2);
        } else if (value2 instanceof Iterable) {
            XContentMapConverter.writeIterable(gen, (Iterable)value2);
        } else if (value2 instanceof Object[]) {
            XContentMapConverter.writeObjectArray(gen, (Object[])value2);
        } else if (type2 == byte[].class) {
            gen.writeBinary((byte[])value2);
        } else if (value2 instanceof Date) {
            gen.writeString(XContentBuilder.defaultDatePrinter.print(((Date)value2).getTime()));
        } else if (value2 instanceof BytesReference) {
            BytesReference bytes2 = (BytesReference)value2;
            if (!bytes2.hasArray()) {
                bytes2 = bytes2.toBytesArray();
            }
            gen.writeBinary(bytes2.array(), bytes2.arrayOffset(), bytes2.length());
        } else if (value2 instanceof Text) {
            Text text = (Text)value2;
            if (text.hasBytes() && text.bytes().hasArray()) {
                gen.writeUTF8String(text.bytes().array(), text.bytes().arrayOffset(), text.bytes().length());
            } else if (text.hasString()) {
                gen.writeString(text.string());
            } else {
                BytesArray bytesArray = text.bytes().toBytesArray();
                gen.writeUTF8String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length());
            }
        } else {
            gen.writeString(value2.toString());
        }
    }

    public static interface MapFactory {
        public Map<String, Object> newMap();
    }
}

