/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Modules;
import org.elasticsearch.common.inject.SpawnModules;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.DiscoveryService;
import org.elasticsearch.discovery.local.LocalDiscoveryModule;
import org.elasticsearch.discovery.zen.ZenDiscoveryModule;

public class DiscoveryModule
extends AbstractModule
implements SpawnModules {
    private final Settings settings;

    public DiscoveryModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    public Iterable<? extends Module> spawnModules() {
        Class defaultDiscoveryModule = this.settings.getAsBoolean("node.local", false) != false ? LocalDiscoveryModule.class : ZenDiscoveryModule.class;
        return ImmutableList.of(Modules.createModule(this.settings.getAsClass("discovery.type", defaultDiscoveryModule, "org.elasticsearch.discovery.", "DiscoveryModule"), this.settings));
    }

    @Override
    protected void configure() {
        this.bind(DiscoveryService.class).asEagerSingleton();
    }
}

