/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.blobstore;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.GatewayAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.gateway.blobstore.BlobStoreGateway;
import org.elasticsearch.index.gateway.CommitPoint;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.internal.InternalNode;
import org.elasticsearch.transport.ConnectTransportException;

public class BlobReuseExistingGatewayAllocator
extends AbstractComponent
implements GatewayAllocator {
    private final Node node;
    private final TransportNodesListShardStoreMetaData listShardStoreMetaData;
    private final TimeValue listTimeout;
    private final ConcurrentMap<ShardId, CommitPoint> cachedCommitPoints = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<ShardId, Map<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData>> cachedStores = ConcurrentCollections.newConcurrentMap();

    @Inject
    public BlobReuseExistingGatewayAllocator(Settings settings, Node node, TransportNodesListShardStoreMetaData transportNodesListShardStoreMetaData) {
        super(settings);
        this.node = node;
        this.listShardStoreMetaData = transportNodesListShardStoreMetaData;
        this.listTimeout = this.componentSettings.getAsTime("list_timeout", TimeValue.timeValueSeconds(30L));
    }

    @Override
    public void applyStartedShards(StartedRerouteAllocation allocation) {
        for (ShardRouting shardRouting : allocation.startedShards()) {
            this.cachedCommitPoints.remove(shardRouting.shardId());
            this.cachedStores.remove(shardRouting.shardId());
        }
    }

    @Override
    public void applyFailedShards(FailedRerouteAllocation allocation) {
        this.cachedCommitPoints.remove(allocation.failedShard().shardId());
        this.cachedStores.remove(allocation.failedShard().shardId());
    }

    @Override
    public boolean allocateUnassigned(RoutingAllocation allocation) {
        boolean changed = false;
        DiscoveryNodes nodes = allocation.nodes();
        RoutingNodes routingNodes = allocation.routingNodes();
        if (nodes.dataNodes().isEmpty()) {
            return changed;
        }
        if (!routingNodes.hasUnassigned()) {
            return changed;
        }
        Iterator<MutableShardRouting> unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            MutableShardRouting shard = unassignedIterator.next();
            boolean canBeAllocatedToAtLeastOneNode = false;
            for (DiscoveryNode discoNode : nodes.dataNodes().values()) {
                Decision decision;
                RoutingNode node = routingNodes.node(discoNode.id());
                if (node == null || (decision = allocation.deciders().canAllocate(shard, node, allocation)).type() != Decision.Type.YES) continue;
                canBeAllocatedToAtLeastOneNode = true;
                break;
            }
            if (!canBeAllocatedToAtLeastOneNode) continue;
            Map<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData> shardStores = this.buildShardStores(nodes, shard);
            long lastSizeMatched = 0L;
            DiscoveryNode lastDiscoNodeMatched = null;
            RoutingNode lastNodeMatched = null;
            for (Map.Entry<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData> nodeStoreEntry : shardStores.entrySet()) {
                TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryNodeStore;
                DiscoveryNode primaryNode;
                RoutingNode node;
                DiscoveryNode discoNode = nodeStoreEntry.getKey();
                TransportNodesListShardStoreMetaData.StoreFilesMetaData storeFilesMetaData = nodeStoreEntry.getValue();
                this.logger.trace("{}: checking node [{}]", shard, discoNode);
                if (storeFilesMetaData == null || (node = routingNodes.node(discoNode.id())) == null || allocation.deciders().canAllocate(shard, node, allocation).type() == Decision.Type.NO || storeFilesMetaData.allocated()) continue;
                if (shard.primary()) {
                    try {
                        CommitPoint commitPoint = (CommitPoint)this.cachedCommitPoints.get(shard.shardId());
                        if (commitPoint == null) {
                            commitPoint = ((BlobStoreGateway)((InternalNode)this.node).injector().getInstance(Gateway.class)).findCommitPoint(shard.index(), shard.id());
                            if (commitPoint != null) {
                                this.cachedCommitPoints.put(shard.shardId(), commitPoint);
                            } else {
                                this.cachedCommitPoints.put(shard.shardId(), CommitPoint.NULL);
                            }
                        } else if (commitPoint == CommitPoint.NULL) {
                            commitPoint = null;
                        }
                        if (commitPoint == null) break;
                        long sizeMatched = 0L;
                        for (StoreFileMetaData storeFileMetaData : storeFilesMetaData) {
                            CommitPoint.FileInfo fileInfo = commitPoint.findPhysicalIndexFile(storeFileMetaData.name());
                            if (fileInfo != null) {
                                if (fileInfo.isSame(storeFileMetaData)) {
                                    this.logger.trace("{}: [{}] reusing file since it exists on remote node and on gateway", shard, storeFileMetaData.name());
                                    sizeMatched += storeFileMetaData.length();
                                    continue;
                                }
                                this.logger.trace("{}: [{}] ignore file since it exists on remote node and on gateway but is different", shard, storeFileMetaData.name());
                                continue;
                            }
                            this.logger.trace("{}: [{}] exists on remote node, does not exists on gateway", shard, storeFileMetaData.name());
                        }
                        if (sizeMatched > lastSizeMatched) {
                            lastSizeMatched = sizeMatched;
                            lastDiscoNodeMatched = discoNode;
                            lastNodeMatched = node;
                            this.logger.trace("{}: node elected for pre_allocation [{}], total_size_matched [{}]", shard, discoNode, new ByteSizeValue(sizeMatched));
                            continue;
                        }
                        this.logger.trace("{}: node ignored for pre_allocation [{}], total_size_matched [{}] smaller than last_size_matched [{}]", shard, discoNode, new ByteSizeValue(sizeMatched), new ByteSizeValue(lastSizeMatched));
                    }
                    catch (Exception e) {
                        this.logger.debug("Failed to guess allocation of primary based on gateway for " + shard, e, new Object[0]);
                    }
                    continue;
                }
                MutableShardRouting primaryShard = routingNodes.findPrimaryForReplica(shard);
                if (primaryShard == null || !primaryShard.active() || (primaryNode = nodes.get(primaryShard.currentNodeId())) == null || (primaryNodeStore = shardStores.get(primaryNode)) == null || !primaryNodeStore.allocated()) continue;
                long sizeMatched = 0L;
                for (StoreFileMetaData storeFileMetaData : storeFilesMetaData) {
                    if (!primaryNodeStore.fileExists(storeFileMetaData.name()) || !primaryNodeStore.file(storeFileMetaData.name()).isSame(storeFileMetaData)) continue;
                    sizeMatched += storeFileMetaData.length();
                }
                if (sizeMatched <= lastSizeMatched) continue;
                lastSizeMatched = sizeMatched;
                lastDiscoNodeMatched = discoNode;
                lastNodeMatched = node;
            }
            if (lastNodeMatched == null) continue;
            if (allocation.deciders().canAllocate(shard, lastNodeMatched, allocation).type() == Decision.Type.THROTTLE) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.debug("[{}][{}]: throttling allocation [{}] to [{}] in order to reuse its unallocated persistent store with total_size [{}]", shard.index(), shard.id(), shard, lastDiscoNodeMatched, new ByteSizeValue(lastSizeMatched));
                }
                unassignedIterator.remove();
                routingNodes.ignoredUnassigned().add(shard);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[{}][{}]: allocating [{}] to [{}] in order to reuse its unallocated persistent store with total_size [{}]", shard.index(), shard.id(), shard, lastDiscoNodeMatched, new ByteSizeValue(lastSizeMatched));
            }
            changed = true;
            lastNodeMatched.add(shard);
            unassignedIterator.remove();
        }
        return changed;
    }

    private Map<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData> buildShardStores(DiscoveryNodes nodes, MutableShardRouting shard) {
        Set<String> nodesIds;
        HashMap<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData> shardStores = (HashMap<DiscoveryNode, TransportNodesListShardStoreMetaData.StoreFilesMetaData>)this.cachedStores.get(shard.shardId());
        if (shardStores == null) {
            shardStores = Maps.newHashMap();
            this.cachedStores.put(shard.shardId(), shardStores);
            nodesIds = nodes.dataNodes().keySet();
        } else {
            nodesIds = Sets.newHashSet();
            Iterator it = shardStores.keySet().iterator();
            while (it.hasNext()) {
                DiscoveryNode node = (DiscoveryNode)it.next();
                if (nodes.nodeExists(node.id())) continue;
                it.remove();
            }
            for (DiscoveryNode node : nodes.dataNodes().values()) {
                if (shardStores.containsKey(node)) continue;
                nodesIds.add(node.id());
            }
        }
        if (!nodesIds.isEmpty()) {
            TransportNodesListShardStoreMetaData.NodesStoreFilesMetaData nodesStoreFilesMetaData = this.listShardStoreMetaData.list(shard.shardId(), false, nodesIds, this.listTimeout).actionGet();
            if (this.logger.isTraceEnabled() && nodesStoreFilesMetaData.failures().length > 0) {
                StringBuilder sb = new StringBuilder(shard + ": failures when trying to list stores on nodes:");
                for (int i2 = 0; i2 < nodesStoreFilesMetaData.failures().length; ++i2) {
                    Throwable cause2 = ExceptionsHelper.unwrapCause(nodesStoreFilesMetaData.failures()[i2]);
                    if (cause2 instanceof ConnectTransportException) continue;
                    sb.append("\n    -> ").append(nodesStoreFilesMetaData.failures()[i2].getDetailedMessage());
                }
                this.logger.trace(sb.toString(), new Object[0]);
            }
            for (TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData nodeStoreFilesMetaData : nodesStoreFilesMetaData) {
                if (nodeStoreFilesMetaData.storeFilesMetaData() == null) continue;
                shardStores.put(nodeStoreFilesMetaData.node(), nodeStoreFilesMetaData.storeFilesMetaData());
            }
        }
        return shardStores;
    }
}

