/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexComponent;
import org.elasticsearch.index.IndexServiceManagement;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.jmx.ManagedGroupName;

public abstract class AbstractIndexComponent
implements IndexComponent {
    protected final ESLogger logger;
    protected final Index index;
    protected final Settings indexSettings;
    protected final Settings componentSettings;

    protected AbstractIndexComponent(Index index2, @IndexSettings Settings indexSettings) {
        this.index = index2;
        this.indexSettings = indexSettings;
        this.componentSettings = indexSettings.getComponentSettings(this.getClass());
        this.logger = Loggers.getLogger(this.getClass(), indexSettings, index2, new String[0]);
    }

    protected AbstractIndexComponent(Index index2, @IndexSettings Settings indexSettings, String prefixSettings) {
        this.index = index2;
        this.indexSettings = indexSettings;
        this.componentSettings = indexSettings.getComponentSettings(prefixSettings, this.getClass());
        this.logger = Loggers.getLogger(this.getClass(), indexSettings, index2, new String[0]);
    }

    @Override
    public Index index() {
        return this.index;
    }

    public String nodeName() {
        return this.indexSettings.get("name", "");
    }

    @ManagedGroupName
    private String managementGroupName() {
        return IndexServiceManagement.buildIndexGroupName(this.index);
    }
}

