/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.index.engine.IgnoreOnRecoveryEngineException;

public class AlreadyExpiredException
extends ElasticSearchException
implements IgnoreOnRecoveryEngineException {
    private String index;
    private String type;
    private String id;
    private final long timestamp;
    private final long ttl;
    private final long now;

    public AlreadyExpiredException(String index2, String type2, String id2, long timestamp, long ttl, long now) {
        super("already expired [" + index2 + "]/[" + type2 + "]/[" + id2 + "] due to expire at [" + (timestamp + ttl) + "] and was processed at [" + now + "]");
        this.index = index2;
        this.type = type2;
        this.id = id2;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.now = now;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long ttl() {
        return this.ttl;
    }

    public long now() {
        return this.now;
    }
}

