/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fr.ElisionFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class ElisionTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Set<?> articles;

    @Inject
    public ElisionTokenFilterFactory(Index index2, @IndexSettings Settings indexSettings, Environment env, @Assisted String name2, @Assisted Settings settings) {
        super(index2, indexSettings, name2, settings);
        this.articles = Analysis.parseArticles(env, settings, this.version);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.articles == null) {
            return new ElisionFilter(this.version, tokenStream);
        }
        return new ElisionFilter(this.version, tokenStream, this.articles);
    }
}

