/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.id.simple;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.trove.ExtTObjectIntHasMap;
import org.elasticsearch.common.trove.impl.hash.TObjectHash;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;

public class SimpleIdReaderTypeCache
implements IdReaderTypeCache {
    private final String type;
    private final ExtTObjectIntHasMap<HashedBytesArray> idToDoc;
    private final HashedBytesArray[] docIdToId;
    private final HashedBytesArray[] parentIdsValues;
    private final int[] parentIdsOrdinals;
    private long sizeInBytes = -1L;

    public SimpleIdReaderTypeCache(String type2, ExtTObjectIntHasMap<HashedBytesArray> idToDoc, HashedBytesArray[] docIdToId, HashedBytesArray[] parentIdsValues, int[] parentIdsOrdinals) {
        this.type = type2;
        this.idToDoc = idToDoc;
        this.docIdToId = docIdToId;
        this.idToDoc.trimToSize();
        this.parentIdsValues = parentIdsValues;
        this.parentIdsOrdinals = parentIdsOrdinals;
    }

    public String type() {
        return this.type;
    }

    @Override
    public HashedBytesArray parentIdByDoc(int docId) {
        return this.parentIdsValues[this.parentIdsOrdinals[docId]];
    }

    @Override
    public int docById(HashedBytesArray uid2) {
        return this.idToDoc.get(uid2);
    }

    @Override
    public HashedBytesArray idByDoc(int docId) {
        return this.docIdToId[docId];
    }

    @Override
    public long sizeInBytes() {
        if (this.sizeInBytes == -1L) {
            this.sizeInBytes = this.computeSizeInBytes();
        }
        return this.sizeInBytes;
    }

    public HashedBytesArray canReuse(HashedBytesArray id2) {
        return this.idToDoc.key(id2);
    }

    long computeSizeInBytes() {
        long sizeInBytes = 0L;
        sizeInBytes += (long)(RamUsage.NUM_BYTES_ARRAY_HEADER + this.idToDoc._valuesSize() * 4);
        for (Object o : this.idToDoc._set) {
            if (o == TObjectHash.FREE || o == TObjectHash.REMOVED) {
                sizeInBytes += (long)RamUsage.NUM_BYTES_OBJECT_REF;
                continue;
            }
            HashedBytesArray bytesArray = (HashedBytesArray)o;
            sizeInBytes += (long)(8 + (bytesArray.length() + 4));
        }
        sizeInBytes += (long)(RamUsage.NUM_BYTES_ARRAY_HEADER + RamUsage.NUM_BYTES_OBJECT_REF * this.docIdToId.length);
        for (HashedBytesArray bytesArray : this.parentIdsValues) {
            if (bytesArray == null) {
                sizeInBytes += (long)RamUsage.NUM_BYTES_OBJECT_REF;
                continue;
            }
            sizeInBytes += (long)(8 + (bytesArray.length() + 4));
        }
        return sizeInBytes += (long)(RamUsage.NUM_BYTES_ARRAY_HEADER + 4 * this.parentIdsOrdinals.length);
    }
}

