/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.deletionpolicy;

import java.util.List;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class KeepOnlyLastDeletionPolicy
extends AbstractIndexShardComponent
implements IndexDeletionPolicy {
    @Inject
    public KeepOnlyLastDeletionPolicy(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
        this.logger.debug("Using [keep_only_last] deletion policy", new Object[0]);
    }

    @Override
    public void onInit(List<? extends IndexCommit> commits) {
        this.onCommit(commits);
    }

    @Override
    public void onCommit(List<? extends IndexCommit> commits) {
        int size2 = commits.size();
        for (int i2 = 0; i2 < size2 - 1; ++i2) {
            commits.get(i2).delete();
        }
    }
}

