/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.bytes;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.trove.list.array.TByteArrayList;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.bytes.ByteDocFieldData;
import org.elasticsearch.index.field.data.bytes.MultiValueByteFieldData;
import org.elasticsearch.index.field.data.bytes.SingleValueByteFieldData;
import org.elasticsearch.index.field.data.support.FieldDataLoader;

public abstract class ByteFieldData
extends NumericFieldData<ByteDocFieldData> {
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected final byte[] values;

    protected ByteFieldData(String fieldName, byte[] values2) {
        super(fieldName);
        this.values = values2;
    }

    @Override
    protected long computeSizeInBytes() {
        return 1 * this.values.length + RamUsage.NUM_BYTES_ARRAY_HEADER;
    }

    public final byte[] values() {
        return this.values;
    }

    public abstract byte value(int var1);

    public abstract byte[] values(int var1);

    @Override
    public ByteDocFieldData docFieldData(int docId) {
        return (ByteDocFieldData)super.docFieldData(docId);
    }

    @Override
    protected ByteDocFieldData createFieldData() {
        return new ByteDocFieldData(this);
    }

    @Override
    public void forEachValue(FieldData.StringValueProc proc2) {
        for (int i2 = 1; i2 < this.values.length; ++i2) {
            proc2.onValue(Byte.toString(this.values[i2]));
        }
    }

    @Override
    public String stringValue(int docId) {
        return Byte.toString(this.value(docId));
    }

    @Override
    public byte byteValue(int docId) {
        return this.value(docId);
    }

    @Override
    public short shortValue(int docId) {
        return this.value(docId);
    }

    @Override
    public int intValue(int docId) {
        return this.value(docId);
    }

    @Override
    public long longValue(int docId) {
        return this.value(docId);
    }

    @Override
    public float floatValue(int docId) {
        return this.value(docId);
    }

    @Override
    public double doubleValue(int docId) {
        return this.value(docId);
    }

    @Override
    public FieldDataType type() {
        return FieldDataType.DefaultTypes.BYTE;
    }

    public void forEachValue(ValueProc proc2) {
        for (int i2 = 1; i2 < this.values.length; ++i2) {
            proc2.onValue(this.values[i2]);
        }
    }

    public abstract void forEachValueInDoc(int var1, ValueInDocProc var2);

    public static ByteFieldData load(IndexReader reader, String field2) throws IOException {
        return FieldDataLoader.load(reader, field2, new ByteTypeLoader());
    }

    static class ByteTypeLoader
    extends FieldDataLoader.FreqsTypeLoader<ByteFieldData> {
        private final TByteArrayList terms = new TByteArrayList();

        ByteTypeLoader() {
            this.terms.add((byte)0);
        }

        @Override
        public void collectTerm(String term) {
            this.terms.add((byte)FieldCache.NUMERIC_UTILS_INT_PARSER.parseInt(term));
        }

        @Override
        public ByteFieldData buildSingleValue(String field2, int[] ordinals) {
            return new SingleValueByteFieldData(field2, ordinals, this.terms.toArray());
        }

        @Override
        public ByteFieldData buildMultiValue(String field2, int[][] ordinals) {
            return new MultiValueByteFieldData(field2, ordinals, this.terms.toArray());
        }
    }

    public static interface ValueInDocProc {
        public void onValue(int var1, byte var2);

        public void onMissing(int var1);
    }

    public static interface ValueProc {
        public void onValue(byte var1);
    }
}

