/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.bytes;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.bytes.ByteFieldData;
import org.elasticsearch.index.field.data.doubles.DoubleFieldData;

public class SingleValueByteFieldData
extends ByteFieldData {
    private ThreadLocal<ThreadLocals.CleanableValue<double[]>> doublesValuesCache = new ThreadLocal<ThreadLocals.CleanableValue<double[]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[]> initialValue() {
            return new ThreadLocals.CleanableValue<double[]>(new double[1]);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<byte[]>> valuesCache = new ThreadLocal<ThreadLocals.CleanableValue<byte[]>>(){

        @Override
        protected ThreadLocals.CleanableValue<byte[]> initialValue() {
            return new ThreadLocals.CleanableValue<byte[]>(new byte[1]);
        }
    };
    private final int[] ordinals;

    public SingleValueByteFieldData(String fieldName, int[] ordinals, byte[] values2) {
        super(fieldName, values2);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        return super.computeSizeInBytes() + (long)(4 * this.ordinals.length) + (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
    }

    @Override
    public boolean multiValued() {
        return false;
    }

    @Override
    public boolean hasValue(int docId) {
        return this.ordinals[docId] != 0;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc2) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            proc2.onMissing(docId);
            return;
        }
        proc2.onValue(docId, Byte.toString(this.values[loc]));
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.DoubleValueInDocProc proc2) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return;
        }
        proc2.onValue(docId, this.values[loc]);
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.LongValueInDocProc proc2) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return;
        }
        proc2.onValue(docId, this.values[loc]);
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingDoubleValueInDocProc proc2) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            proc2.onMissing(docId);
            return;
        }
        proc2.onValue(docId, this.values[loc]);
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingLongValueInDocProc proc2) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            proc2.onMissing(docId);
            return;
        }
        proc2.onValue(docId, this.values[loc]);
    }

    @Override
    public void forEachValueInDoc(int docId, ByteFieldData.ValueInDocProc proc2) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            proc2.onMissing(docId);
            return;
        }
        proc2.onValue(docId, this.values[loc]);
    }

    @Override
    public void forEachOrdinalInDoc(int docId, FieldData.OrdinalInDocProc proc2) {
        proc2.onOrdinal(docId, this.ordinals[docId]);
    }

    @Override
    public byte value(int docId) {
        return this.values[this.ordinals[docId]];
    }

    @Override
    public double[] doubleValues(int docId) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] ret = this.doublesValuesCache.get().get();
        ret[0] = this.values[loc];
        return ret;
    }

    @Override
    public byte[] values(int docId) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] ret = this.valuesCache.get().get();
        ret[0] = this.values[loc];
        return ret;
    }
}

