/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.ints;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.doubles.DoubleFieldData;
import org.elasticsearch.index.field.data.ints.IntFieldData;

public class MultiValueIntFieldData
extends IntFieldData {
    private static final int VALUE_CACHE_SIZE = 10;
    private ThreadLocal<ThreadLocals.CleanableValue<double[][]>> doublesValuesCache = new ThreadLocal<ThreadLocals.CleanableValue<double[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[][]> initialValue() {
            double[][] value2 = new double[10][];
            for (int i2 = 0; i2 < value2.length; ++i2) {
                value2[i2] = new double[i2];
            }
            return new ThreadLocals.CleanableValue<double[][]>(value2);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<int[][]>> valuesCache = new ThreadLocal<ThreadLocals.CleanableValue<int[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<int[][]> initialValue() {
            int[][] value2 = new int[10][];
            for (int i2 = 0; i2 < value2.length; ++i2) {
                value2[i2] = new int[i2];
            }
            return new ThreadLocals.CleanableValue<int[][]>(value2);
        }
    };
    private final int[][] ordinals;

    public MultiValueIntFieldData(String fieldName, int[][] ordinals, int[] values2) {
        super(fieldName, values2);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        long size2 = super.computeSizeInBytes();
        size2 += (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
        for (int[] ordinal : this.ordinals) {
            size2 += (long)(4 * ordinal.length + RamUsage.NUM_BYTES_ARRAY_HEADER);
        }
        return size2;
    }

    @Override
    public boolean multiValued() {
        return true;
    }

    @Override
    public boolean hasValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onMissing(docId);
                break;
            }
            proc2.onValue(docId, Integer.toString(this.values[loc]));
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.DoubleValueInDocProc proc2) {
        int[] ordinal;
        int loc;
        int[][] arr$ = this.ordinals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (loc = (ordinal = arr$[i$])[docId]) != 0; ++i$) {
            proc2.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.LongValueInDocProc proc2) {
        int[] ordinal;
        int loc;
        int[][] arr$ = this.ordinals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (loc = (ordinal = arr$[i$])[docId]) != 0; ++i$) {
            proc2.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingDoubleValueInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onMissing(docId);
                break;
            }
            proc2.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingLongValueInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onMissing(docId);
                break;
            }
            proc2.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, IntFieldData.ValueInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onMissing(docId);
                break;
            }
            proc2.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachOrdinalInDoc(int docId, FieldData.OrdinalInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onOrdinal(docId, 0);
                break;
            }
            proc2.onOrdinal(docId, loc);
        }
    }

    @Override
    public double[] doubleValues(int docId) {
        int length2 = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) break;
            ++length2;
        }
        if (length2 == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] doubles = length2 < 10 ? this.doublesValuesCache.get().get()[length2] : new double[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            doubles[i2] = this.values[this.ordinals[i2][docId]];
        }
        return doubles;
    }

    @Override
    public int value(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            return this.values[loc];
        }
        return 0;
    }

    @Override
    public int[] values(int docId) {
        int length2 = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) break;
            ++length2;
        }
        if (length2 == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] ints = length2 < 10 ? this.valuesCache.get().get()[length2] : new int[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            ints[i2] = this.values[this.ordinals[i2][docId]];
        }
        return ints;
    }
}

