/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.longs;

import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.support.NumericFieldDataComparator;

public class LongFieldDataMissingComparator
extends NumericFieldDataComparator {
    private final long[] values;
    private long bottom;
    private final long missingValue;

    public LongFieldDataMissingComparator(int numHits, String fieldName, FieldDataCache fieldDataCache, long missingValue) {
        super(fieldName, fieldDataCache);
        this.values = new long[numHits];
        this.missingValue = missingValue;
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.LONG;
    }

    @Override
    public int compare(int slot1, int slot2) {
        long v1 = this.values[slot1];
        long v2 = this.values[slot2];
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compareBottom(int doc) {
        long v2 = this.missingValue;
        if (this.currentFieldData.hasValue(doc)) {
            v2 = this.currentFieldData.longValue(doc);
        }
        if (this.bottom > v2) {
            return 1;
        }
        if (this.bottom < v2) {
            return -1;
        }
        return 0;
    }

    @Override
    public void copy(int slot, int doc) {
        long value2 = this.missingValue;
        if (this.currentFieldData.hasValue(doc)) {
            value2 = this.currentFieldData.longValue(doc);
        }
        this.values[slot] = value2;
    }

    @Override
    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return Long.valueOf(this.values[slot]);
    }
}

