/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.longs;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.MutableDateTime;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.doubles.DoubleFieldData;
import org.elasticsearch.index.field.data.longs.LongFieldData;

public class MultiValueLongFieldData
extends LongFieldData {
    private static final int VALUE_CACHE_SIZE = 10;
    private ThreadLocal<ThreadLocals.CleanableValue<double[][]>> doublesValuesCache = new ThreadLocal<ThreadLocals.CleanableValue<double[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[][]> initialValue() {
            double[][] value2 = new double[10][];
            for (int i2 = 0; i2 < value2.length; ++i2) {
                value2[i2] = new double[i2];
            }
            return new ThreadLocals.CleanableValue<double[][]>(value2);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<MutableDateTime[][]>> dateTimesCache = new ThreadLocal<ThreadLocals.CleanableValue<MutableDateTime[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<MutableDateTime[][]> initialValue() {
            MutableDateTime[][] value2 = new MutableDateTime[10][];
            for (int i2 = 0; i2 < value2.length; ++i2) {
                value2[i2] = new MutableDateTime[i2];
                for (int j = 0; j < i2; ++j) {
                    value2[i2][j] = new MutableDateTime(DateTimeZone.UTC);
                }
            }
            return new ThreadLocals.CleanableValue<MutableDateTime[][]>(value2);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<long[][]>> valuesCache = new ThreadLocal<ThreadLocals.CleanableValue<long[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<long[][]> initialValue() {
            long[][] value2 = new long[10][];
            for (int i2 = 0; i2 < value2.length; ++i2) {
                value2[i2] = new long[i2];
            }
            return new ThreadLocals.CleanableValue<long[][]>(value2);
        }
    };
    private final int[][] ordinals;

    public MultiValueLongFieldData(String fieldName, int[][] ordinals, long[] values2) {
        super(fieldName, values2);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        long size2 = super.computeSizeInBytes();
        size2 += (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
        for (int[] ordinal : this.ordinals) {
            size2 += (long)(4 * ordinal.length + RamUsage.NUM_BYTES_ARRAY_HEADER);
        }
        return size2;
    }

    @Override
    public boolean multiValued() {
        return true;
    }

    @Override
    public boolean hasValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onMissing(docId);
                break;
            }
            proc2.onValue(docId, Long.toString(this.values[loc]));
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.DoubleValueInDocProc proc2) {
        int[] ordinal;
        int loc;
        int[][] arr$ = this.ordinals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (loc = (ordinal = arr$[i$])[docId]) != 0; ++i$) {
            proc2.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.LongValueInDocProc proc2) {
        int[] ordinal;
        int loc;
        int[][] arr$ = this.ordinals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (loc = (ordinal = arr$[i$])[docId]) != 0; ++i$) {
            proc2.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingDoubleValueInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onMissing(docId);
                break;
            }
            proc2.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.MissingLongValueInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onMissing(docId);
                break;
            }
            proc2.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachOrdinalInDoc(int docId, FieldData.OrdinalInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onOrdinal(docId, 0);
                break;
            }
            proc2.onOrdinal(docId, loc);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, LongFieldData.ValueInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onMissing(docId);
                break;
            }
            proc2.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, LongFieldData.DateValueInDocProc proc2) {
        int[] ordinal;
        int loc;
        MutableDateTime dateTime = (MutableDateTime)((ThreadLocals.CleanableValue)this.dateTimeCache.get()).get();
        int[][] arr$ = this.ordinals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (loc = (ordinal = arr$[i$])[docId]) != 0; ++i$) {
            dateTime.setMillis(this.values[loc]);
            proc2.onValue(docId, dateTime);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, MutableDateTime dateTime, LongFieldData.DateValueInDocProc proc2) {
        int[] ordinal;
        int loc;
        int[][] arr$ = this.ordinals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (loc = (ordinal = arr$[i$])[docId]) != 0; ++i$) {
            dateTime.setMillis(this.values[loc]);
            proc2.onValue(docId, dateTime);
        }
    }

    @Override
    public MutableDateTime[] dates(int docId) {
        int i2;
        MutableDateTime[] dates;
        int length2 = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            ++length2;
        }
        if (length2 == 0) {
            return EMPTY_DATETIME_ARRAY;
        }
        if (length2 < 10) {
            dates = this.dateTimesCache.get().get()[length2];
        } else {
            dates = new MutableDateTime[length2];
            for (i2 = 0; i2 < dates.length; ++i2) {
                dates[i2] = new MutableDateTime();
            }
        }
        i2 = 0;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            dates[i2++].setMillis(this.values[loc]);
        }
        return dates;
    }

    @Override
    public double[] doubleValues(int docId) {
        int length2 = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) break;
            ++length2;
        }
        if (length2 == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] doubles = length2 < 10 ? this.doublesValuesCache.get().get()[length2] : new double[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            doubles[i2] = this.values[this.ordinals[i2][docId]];
        }
        return doubles;
    }

    @Override
    public long value(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            return this.values[loc];
        }
        return 0L;
    }

    @Override
    public long[] values(int docId) {
        int length2 = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) break;
            ++length2;
        }
        if (length2 == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] longs = length2 < 10 ? this.valuesCache.get().get()[length2] : new long[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            longs[i2] = this.values[this.ordinals[i2][docId]];
        }
        return longs;
    }
}

