/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.shorts;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.trove.list.array.TShortArrayList;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.shorts.MultiValueShortFieldData;
import org.elasticsearch.index.field.data.shorts.ShortDocFieldData;
import org.elasticsearch.index.field.data.shorts.SingleValueShortFieldData;
import org.elasticsearch.index.field.data.support.FieldDataLoader;

public abstract class ShortFieldData
extends NumericFieldData<ShortDocFieldData> {
    static final short[] EMPTY_SHORT_ARRAY = new short[0];
    protected final short[] values;

    protected ShortFieldData(String fieldName, short[] values2) {
        super(fieldName);
        this.values = values2;
    }

    @Override
    protected long computeSizeInBytes() {
        return 2 * this.values.length + RamUsage.NUM_BYTES_ARRAY_HEADER;
    }

    public final short[] values() {
        return this.values;
    }

    public abstract short value(int var1);

    public abstract short[] values(int var1);

    @Override
    public ShortDocFieldData docFieldData(int docId) {
        return (ShortDocFieldData)super.docFieldData(docId);
    }

    @Override
    protected ShortDocFieldData createFieldData() {
        return new ShortDocFieldData(this);
    }

    @Override
    public void forEachValue(FieldData.StringValueProc proc2) {
        for (int i2 = 1; i2 < this.values.length; ++i2) {
            proc2.onValue(Short.toString(this.values[i2]));
        }
    }

    @Override
    public String stringValue(int docId) {
        return Short.toString(this.value(docId));
    }

    @Override
    public byte byteValue(int docId) {
        return (byte)this.value(docId);
    }

    @Override
    public short shortValue(int docId) {
        return this.value(docId);
    }

    @Override
    public int intValue(int docId) {
        return this.value(docId);
    }

    @Override
    public long longValue(int docId) {
        return this.value(docId);
    }

    @Override
    public float floatValue(int docId) {
        return this.value(docId);
    }

    @Override
    public double doubleValue(int docId) {
        return this.value(docId);
    }

    @Override
    public FieldDataType type() {
        return FieldDataType.DefaultTypes.SHORT;
    }

    public void forEachValue(ValueProc proc2) {
        for (int i2 = 1; i2 < this.values.length; ++i2) {
            proc2.onValue(this.values[i2]);
        }
    }

    public abstract void forEachValueInDoc(int var1, ValueInDocProc var2);

    public static ShortFieldData load(IndexReader reader, String field2) throws IOException {
        return FieldDataLoader.load(reader, field2, new ShortTypeLoader());
    }

    static class ShortTypeLoader
    extends FieldDataLoader.FreqsTypeLoader<ShortFieldData> {
        private final TShortArrayList terms = new TShortArrayList();

        ShortTypeLoader() {
            this.terms.add((short)0);
        }

        @Override
        public void collectTerm(String term) {
            this.terms.add((short)FieldCache.NUMERIC_UTILS_INT_PARSER.parseInt(term));
        }

        @Override
        public ShortFieldData buildSingleValue(String field2, int[] ordinals) {
            return new SingleValueShortFieldData(field2, ordinals, this.terms.toArray());
        }

        @Override
        public ShortFieldData buildMultiValue(String field2, int[][] ordinals) {
            return new MultiValueShortFieldData(field2, ordinals, this.terms.toArray());
        }
    }

    public static interface ValueInDocProc {
        public void onValue(int var1, short var2);

        public void onMissing(int var1);
    }

    public static interface ValueProc {
        public void onValue(short var1);
    }
}

