/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.strings;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.strings.StringFieldData;

public class SingleValueStringFieldData
extends StringFieldData {
    private static ThreadLocal<ThreadLocals.CleanableValue<String[]>> valuesCache = new ThreadLocal<ThreadLocals.CleanableValue<String[]>>(){

        @Override
        protected ThreadLocals.CleanableValue<String[]> initialValue() {
            return new ThreadLocals.CleanableValue<String[]>(new String[1]);
        }
    };
    private final int[] ordinals;

    public SingleValueStringFieldData(String fieldName, int[] ordinals, String[] values2) {
        super(fieldName, values2);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        return super.computeSizeInBytes() + (long)(4 * this.ordinals.length) + (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
    }

    int[] ordinals() {
        return this.ordinals;
    }

    @Override
    public void forEachOrdinalInDoc(int docId, FieldData.OrdinalInDocProc proc2) {
        proc2.onOrdinal(docId, this.ordinals[docId]);
    }

    @Override
    public boolean multiValued() {
        return false;
    }

    @Override
    public boolean hasValue(int docId) {
        return this.ordinals[docId] != 0;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc2) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            proc2.onMissing(docId);
            return;
        }
        proc2.onValue(docId, this.values[loc]);
    }

    @Override
    public String value(int docId) {
        return this.values[this.ordinals[docId]];
    }

    @Override
    public String[] values(int docId) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return Strings.EMPTY_ARRAY;
        }
        String[] ret = valuesCache.get().get();
        ret[0] = this.values[loc];
        return ret;
    }
}

