/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway;

import java.util.List;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.index.store.StoreFileMetaData;

public class CommitPoint {
    public static final CommitPoint NULL = new CommitPoint(-1L, "_null_", Type.GENERATED, ImmutableList.<FileInfo>of(), ImmutableList.<FileInfo>of());
    private final long version;
    private final String name;
    private final Type type;
    private final ImmutableList<FileInfo> indexFiles;
    private final ImmutableList<FileInfo> translogFiles;

    public CommitPoint(long version, String name2, Type type2, List<FileInfo> indexFiles, List<FileInfo> translogFiles) {
        this.version = version;
        this.name = name2;
        this.type = type2;
        this.indexFiles = ImmutableList.copyOf(indexFiles);
        this.translogFiles = ImmutableList.copyOf(translogFiles);
    }

    public long version() {
        return this.version;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public ImmutableList<FileInfo> indexFiles() {
        return this.indexFiles;
    }

    public ImmutableList<FileInfo> translogFiles() {
        return this.translogFiles;
    }

    public boolean containPhysicalIndexFile(String physicalName) {
        return this.findPhysicalIndexFile(physicalName) != null;
    }

    public FileInfo findPhysicalIndexFile(String physicalName) {
        for (FileInfo file2 : this.indexFiles) {
            if (!file2.physicalName().equals(physicalName)) continue;
            return file2;
        }
        return null;
    }

    public FileInfo findNameFile(String name2) {
        FileInfo fileInfo = this.findNameIndexFile(name2);
        if (fileInfo != null) {
            return fileInfo;
        }
        return this.findNameTranslogFile(name2);
    }

    public FileInfo findNameIndexFile(String name2) {
        for (FileInfo file2 : this.indexFiles) {
            if (!file2.name().equals(name2)) continue;
            return file2;
        }
        return null;
    }

    public FileInfo findNameTranslogFile(String name2) {
        for (FileInfo file2 : this.translogFiles) {
            if (!file2.name().equals(name2)) continue;
            return file2;
        }
        return null;
    }

    public static enum Type {
        GENERATED,
        SAVED;

    }

    public static class FileInfo {
        private final String name;
        private final String physicalName;
        private final long length;
        private final String checksum;

        public FileInfo(String name2, String physicalName, long length2, String checksum) {
            this.name = name2;
            this.physicalName = physicalName;
            this.length = length2;
            this.checksum = checksum;
        }

        public String name() {
            return this.name;
        }

        public String physicalName() {
            return this.physicalName;
        }

        public long length() {
            return this.length;
        }

        @Nullable
        public String checksum() {
            return this.checksum;
        }

        public boolean isSame(StoreFileMetaData md) {
            if (this.checksum == null || md.checksum() == null) {
                return false;
            }
            return this.length == md.length() && this.checksum.equals(md.checksum());
        }
    }
}

