/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway.blobstore;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.gateway.blobstore.BlobStoreGateway;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.gateway.IndexGateway;
import org.elasticsearch.index.settings.IndexSettings;

public abstract class BlobStoreIndexGateway
extends AbstractIndexComponent
implements IndexGateway {
    private final BlobStoreGateway gateway;
    private final BlobStore blobStore;
    private final BlobPath indexPath;
    protected ByteSizeValue chunkSize;

    protected BlobStoreIndexGateway(Index index2, @IndexSettings Settings indexSettings, Gateway gateway) {
        super(index2, indexSettings);
        if (gateway.type().equals("none")) {
            this.logger.warn("index gateway is configured, but no cluster level gateway configured, cluster level metadata will be lost on full shutdown", new Object[0]);
        }
        this.gateway = (BlobStoreGateway)gateway;
        this.blobStore = this.gateway.blobStore();
        this.chunkSize = this.componentSettings.getAsBytesSize("chunk_size", this.gateway.chunkSize());
        this.indexPath = this.gateway.basePath().add("indices").add(index2.name());
    }

    public String toString() {
        return this.type() + "://" + this.blobStore + "/" + this.indexPath;
    }

    public BlobStore blobStore() {
        return this.blobStore;
    }

    public ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    public BlobPath shardPath(int shardId) {
        return this.indexPath.add(Integer.toString(shardId));
    }

    public static BlobPath shardPath(BlobPath basePath, String index2, int shardId) {
        return basePath.add("indices").add(index2).add(Integer.toString(shardId));
    }

    @Override
    public void close(boolean delete2) throws ElasticSearchException {
        if (delete2) {
            this.blobStore.delete(this.indexPath);
        }
    }
}

