/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;

public class TypeParsers {
    public static final String INDEX_OPTIONS_DOCS = "docs";
    public static final String INDEX_OPTIONS_FREQS = "freqs";
    public static final String INDEX_OPTIONS_POSITIONS = "positions";

    public static void parseNumberField(NumberFieldMapper.Builder builder, String name2, Map<String, Object> numberNode, Mapper.TypeParser.ParserContext parserContext) {
        TypeParsers.parseField(builder, name2, numberNode, parserContext);
        for (Map.Entry<String, Object> entry : numberNode.entrySet()) {
            String propName = Strings.toUnderscoreCase(entry.getKey());
            Object propNode = entry.getValue();
            if (propName.equals("precision_step")) {
                builder.precisionStep(XContentMapValues.nodeIntegerValue(propNode));
                continue;
            }
            if (propName.equals("fuzzy_factor")) {
                builder.fuzzyFactor(propNode.toString());
                continue;
            }
            if (!propName.equals("ignore_malformed")) continue;
            builder.ignoreMalformed(XContentMapValues.nodeBooleanValue(propNode));
        }
    }

    public static void parseField(AbstractFieldMapper.Builder builder, String name2, Map<String, Object> fieldNode, Mapper.TypeParser.ParserContext parserContext) {
        for (Map.Entry<String, Object> entry : fieldNode.entrySet()) {
            NamedAnalyzer analyzer;
            String propName = Strings.toUnderscoreCase(entry.getKey());
            Object propNode = entry.getValue();
            if (propName.equals("index_name")) {
                builder.indexName(propNode.toString());
                continue;
            }
            if (propName.equals("store")) {
                builder.store(TypeParsers.parseStore(name2, propNode.toString()));
                continue;
            }
            if (propName.equals("index")) {
                builder.index(TypeParsers.parseIndex(name2, propNode.toString()));
                continue;
            }
            if (propName.equals("term_vector")) {
                builder.termVector(TypeParsers.parseTermVector(name2, propNode.toString()));
                continue;
            }
            if (propName.equals("boost")) {
                builder.boost(XContentMapValues.nodeFloatValue(propNode));
                continue;
            }
            if (propName.equals("omit_norms")) {
                builder.omitNorms(XContentMapValues.nodeBooleanValue(propNode));
                continue;
            }
            if (propName.equals("omit_term_freq_and_positions")) {
                builder.indexOptions(XContentMapValues.nodeBooleanValue(propNode) ? FieldInfo.IndexOptions.DOCS_ONLY : FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
                continue;
            }
            if (propName.equals("index_options")) {
                builder.indexOptions(TypeParsers.nodeIndexOptionValue(propNode));
                continue;
            }
            if (propName.equals("analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name2 + "]");
                }
                builder.indexAnalyzer(analyzer);
                builder.searchAnalyzer(analyzer);
                continue;
            }
            if (propName.equals("index_analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name2 + "]");
                }
                builder.indexAnalyzer(analyzer);
                continue;
            }
            if (propName.equals("search_analyzer")) {
                analyzer = parserContext.analysisService().analyzer(propNode.toString());
                if (analyzer == null) {
                    throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name2 + "]");
                }
                builder.searchAnalyzer(analyzer);
                continue;
            }
            if (!propName.equals("include_in_all")) continue;
            builder.includeInAll(XContentMapValues.nodeBooleanValue(propNode));
        }
    }

    private static FieldInfo.IndexOptions nodeIndexOptionValue(Object propNode) {
        String value2 = propNode.toString();
        if (INDEX_OPTIONS_POSITIONS.equalsIgnoreCase(value2)) {
            return FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        }
        if (INDEX_OPTIONS_FREQS.equalsIgnoreCase(value2)) {
            return FieldInfo.IndexOptions.DOCS_AND_FREQS;
        }
        if (INDEX_OPTIONS_DOCS.equalsIgnoreCase(value2)) {
            return FieldInfo.IndexOptions.DOCS_ONLY;
        }
        throw new ElasticSearchParseException("Failed to parse index option [" + value2 + "]");
    }

    public static FormatDateTimeFormatter parseDateTimeFormatter(String fieldName, Object node) {
        return Joda.forPattern(node.toString());
    }

    public static Field.TermVector parseTermVector(String fieldName, String termVector) throws MapperParsingException {
        if ("no".equals(termVector = Strings.toUnderscoreCase(termVector))) {
            return Field.TermVector.NO;
        }
        if ("yes".equals(termVector)) {
            return Field.TermVector.YES;
        }
        if ("with_offsets".equals(termVector)) {
            return Field.TermVector.WITH_OFFSETS;
        }
        if ("with_positions".equals(termVector)) {
            return Field.TermVector.WITH_POSITIONS;
        }
        if ("with_positions_offsets".equals(termVector)) {
            return Field.TermVector.WITH_POSITIONS_OFFSETS;
        }
        throw new MapperParsingException("Wrong value for termVector [" + termVector + "] for field [" + fieldName + "]");
    }

    public static Field.Index parseIndex(String fieldName, String index2) throws MapperParsingException {
        if ("no".equals(index2 = Strings.toUnderscoreCase(index2))) {
            return Field.Index.NO;
        }
        if ("not_analyzed".equals(index2)) {
            return Field.Index.NOT_ANALYZED;
        }
        if ("analyzed".equals(index2)) {
            return Field.Index.ANALYZED;
        }
        throw new MapperParsingException("Wrong value for index [" + index2 + "] for field [" + fieldName + "]");
    }

    public static Field.Store parseStore(String fieldName, String store) throws MapperParsingException {
        if ("no".equals(store)) {
            return Field.Store.NO;
        }
        if ("yes".equals(store)) {
            return Field.Store.YES;
        }
        boolean value2 = XContentMapValues.nodeBooleanValue(store);
        if (value2) {
            return Field.Store.YES;
        }
        return Field.Store.NO;
    }

    public static ContentPath.Type parsePathType(String name2, String path2) throws MapperParsingException {
        if ("just_name".equals(path2 = Strings.toUnderscoreCase(path2))) {
            return ContentPath.Type.JUST_NAME;
        }
        if ("full".equals(path2)) {
            return ContentPath.Type.FULL;
        }
        throw new MapperParsingException("Wrong value for pathType [" + path2 + "] for object [" + name2 + "]");
    }
}

