/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.ip;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericAnalyzer;
import org.elasticsearch.index.analysis.NumericTokenizer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class IpFieldMapper
extends NumberFieldMapper<Long> {
    public static final String CONTENT_TYPE = "ip";
    private static final Pattern pattern = Pattern.compile("\\.");
    private String nullValue;

    public static String longToIp(long longIp) {
        int octet3 = (int)((longIp >> 24) % 256L);
        int octet2 = (int)((longIp >> 16) % 256L);
        int octet1 = (int)((longIp >> 8) % 256L);
        int octet0 = (int)(longIp % 256L);
        return octet3 + "." + octet2 + "." + octet1 + "." + octet0;
    }

    public static long ipToLong(String ip2) throws ElasticSearchIllegalArgumentException {
        try {
            String[] octets = pattern.split(ip2);
            if (octets.length != 4) {
                throw new ElasticSearchIllegalArgumentException("failed to parse ip [" + ip2 + "], not full ip address (4 dots)");
            }
            return (Long.parseLong(octets[0]) << 24) + (long)(Integer.parseInt(octets[1]) << 16) + (long)(Integer.parseInt(octets[2]) << 8) + (long)Integer.parseInt(octets[3]);
        }
        catch (Exception e) {
            if (e instanceof ElasticSearchIllegalArgumentException) {
                throw (ElasticSearchIllegalArgumentException)e;
            }
            throw new ElasticSearchIllegalArgumentException("failed to parse ip [" + ip2 + "]", e);
        }
    }

    protected IpFieldMapper(FieldMapper.Names names2, int precisionStep, Field.Index index2, Field.Store store, float boost, boolean omitNorms, FieldInfo.IndexOptions indexOptions, String nullValue, Explicit<Boolean> ignoreMalformed) {
        super(names2, precisionStep, null, index2, store, boost, omitNorms, indexOptions, ignoreMalformed, new NamedAnalyzer("_ip/" + precisionStep, new NumericIpAnalyzer(precisionStep)), new NamedAnalyzer("_ip/max", new NumericIpAnalyzer(Integer.MAX_VALUE)));
        this.nullValue = nullValue;
    }

    @Override
    protected int maxPrecisionStep() {
        return 64;
    }

    @Override
    public Long value(Fieldable field2) {
        byte[] value2 = field2.getBinaryValue();
        if (value2 == null) {
            return null;
        }
        return Numbers.bytesToLong(value2);
    }

    @Override
    public Long valueFromString(String value2) {
        return IpFieldMapper.ipToLong(value2);
    }

    @Override
    public Object valueForSearch(Fieldable field2) {
        return this.valueAsString(field2);
    }

    @Override
    public String valueAsString(Fieldable field2) {
        Long value2 = this.value(field2);
        if (value2 == null) {
            return null;
        }
        return IpFieldMapper.longToIp(value2);
    }

    @Override
    public String indexedValue(String value2) {
        return NumericUtils.longToPrefixCoded(IpFieldMapper.ipToLong(value2));
    }

    @Override
    public Query fuzzyQuery(String value2, String minSim, int prefixLength, int maxExpansions) {
        long iSim;
        long iValue = IpFieldMapper.ipToLong(value2);
        try {
            iSim = IpFieldMapper.ipToLong(minSim);
        }
        catch (ElasticSearchIllegalArgumentException e) {
            try {
                iSim = Long.parseLong(minSim);
            }
            catch (NumberFormatException e1) {
                iSim = (long)Double.parseDouble(minSim);
            }
        }
        return NumericRangeQuery.newLongRange(this.names.indexName(), this.precisionStep, iValue - iSim, iValue + iSim, true, true);
    }

    @Override
    public Query fuzzyQuery(String value2, double minSim, int prefixLength, int maxExpansions) {
        return new FuzzyQuery(this.names().createIndexNameTerm(value2), (float)minSim, prefixLength, maxExpansions);
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeQuery.newLongRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Long.valueOf(IpFieldMapper.ipToLong(lowerTerm)), upperTerm == null ? null : Long.valueOf(IpFieldMapper.ipToLong(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFilter.newLongRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Long.valueOf(IpFieldMapper.ipToLong(lowerTerm)), upperTerm == null ? null : Long.valueOf(IpFieldMapper.ipToLong(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(FieldDataCache fieldDataCache, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFieldDataFilter.newLongRange(fieldDataCache, this.names.indexName(), lowerTerm == null ? null : Long.valueOf(IpFieldMapper.ipToLong(lowerTerm)), upperTerm == null ? null : Long.valueOf(IpFieldMapper.ipToLong(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        long value2 = IpFieldMapper.ipToLong(this.nullValue);
        return NumericRangeFilter.newLongRange(this.names.indexName(), this.precisionStep, value2, value2, true, true);
    }

    @Override
    protected Fieldable innerParseCreateField(ParseContext context) throws IOException {
        String ipAsString;
        if (context.externalValueSet()) {
            ipAsString = (String)context.externalValue();
            if (ipAsString == null) {
                ipAsString = this.nullValue;
            }
        } else {
            ipAsString = context.parser().currentToken() == XContentParser.Token.VALUE_NULL ? this.nullValue : context.parser().text();
        }
        if (ipAsString == null) {
            return null;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.names.fullName(), ipAsString, this.boost);
        }
        long value2 = IpFieldMapper.ipToLong(ipAsString);
        return new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, value2);
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.LONG;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((IpFieldMapper)mergeWith).nullValue;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (!this.omitNorms) {
            builder.field("omit_norms", this.omitNorms);
        }
        if (this.indexOptions != Defaults.INDEX_OPTIONS) {
            builder.field("index_options", IpFieldMapper.indexOptionToString(this.indexOptions));
        }
        if (this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
    }

    public static class NumericIpTokenizer
    extends NumericTokenizer {
        public NumericIpTokenizer(Reader reader, int precisionStep) throws IOException {
            super(reader, new NumericTokenStream(precisionStep), null);
        }

        public NumericIpTokenizer(Reader reader, int precisionStep, char[] buffer) throws IOException {
            super(reader, new NumericTokenStream(precisionStep), buffer, null);
        }

        @Override
        protected void setValue(NumericTokenStream tokenStream, String value2) {
            tokenStream.setLongValue(IpFieldMapper.ipToLong(value2));
        }
    }

    public static class NumericIpAnalyzer
    extends NumericAnalyzer<NumericIpTokenizer> {
        private final int precisionStep;

        public NumericIpAnalyzer() {
            this(4);
        }

        public NumericIpAnalyzer(int precisionStep) {
            this.precisionStep = precisionStep;
        }

        @Override
        protected NumericIpTokenizer createNumericTokenizer(Reader reader, char[] buffer) throws IOException {
            return new NumericIpTokenizer(reader, this.precisionStep, buffer);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name2, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.ipField(name2);
            TypeParsers.parseNumberField(builder, name2, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(propNode.toString());
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, IpFieldMapper> {
        protected String nullValue = Defaults.NULL_VALUE;

        public Builder(String name2) {
            super(name2);
            this.builder = this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public IpFieldMapper build(Mapper.BuilderContext context) {
            IpFieldMapper fieldMapper = new IpFieldMapper(this.buildNames(context), this.precisionStep, this.index, this.store, this.boost, this.omitNorms, this.indexOptions, this.nullValue, this.ignoreMalformed(context));
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final String NULL_VALUE = null;
    }
}

