/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class CustomBoostFactorQueryBuilder
extends BaseQueryBuilder {
    private final QueryBuilder queryBuilder;
    private float boostFactor = -1.0f;

    public CustomBoostFactorQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public CustomBoostFactorQueryBuilder boostFactor(float boost) {
        this.boostFactor = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("custom_boost_factor");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params2);
        if (this.boostFactor != -1.0f) {
            builder.field("boost_factor", this.boostFactor);
        }
        builder.endObject();
    }
}

