/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import org.elasticsearch.common.geo.GeoJSONShapeSerializer;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class GeoShapeQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<GeoShapeQueryBuilder> {
    private final String name;
    private final Shape shape;
    private ShapeRelation relation = ShapeRelation.INTERSECTS;
    private float boost = -1.0f;
    private final String indexedShapeId;
    private final String indexedShapeType;
    private String indexedShapeIndex;
    private String indexedShapeFieldName;

    public GeoShapeQueryBuilder(String name2, Shape shape) {
        this(name2, shape, null, null);
    }

    public GeoShapeQueryBuilder(String name2, String indexedShapeId, String indexedShapeType) {
        this(name2, null, indexedShapeId, indexedShapeType);
    }

    private GeoShapeQueryBuilder(String name2, Shape shape, String indexedShapeId, String indexedShapeType) {
        this.name = name2;
        this.shape = shape;
        this.indexedShapeId = indexedShapeId;
        this.indexedShapeType = indexedShapeType;
    }

    public GeoShapeQueryBuilder relation(ShapeRelation relation) {
        this.relation = relation;
        return this;
    }

    @Override
    public GeoShapeQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public GeoShapeQueryBuilder indexedShapeIndex(String indexedShapeIndex) {
        this.indexedShapeIndex = indexedShapeIndex;
        return this;
    }

    public GeoShapeQueryBuilder indexedShapeFieldName(String indexedShapeFieldName) {
        this.indexedShapeFieldName = indexedShapeFieldName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("geo_shape");
        builder.startObject(this.name);
        builder.field("relation", this.relation.getRelationName());
        if (this.shape != null) {
            builder.startObject("shape");
            GeoJSONShapeSerializer.serialize(this.shape, builder);
            builder.endObject();
        } else {
            builder.startObject("indexed_shape").field("id", this.indexedShapeId).field("type", this.indexedShapeType);
            if (this.indexedShapeIndex != null) {
                builder.field("index", this.indexedShapeIndex);
            }
            if (this.indexedShapeFieldName != null) {
                builder.field("shape_field_name", this.indexedShapeFieldName);
            }
            builder.endObject();
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

