/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class HasParentQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<HasParentQueryBuilder> {
    private final QueryBuilder queryBuilder;
    private final String parentType;
    private String scoreType;
    private String executionType;
    private String scope;
    private float boost = 1.0f;

    public HasParentQueryBuilder(String parentType, QueryBuilder parentQuery) {
        this.parentType = parentType;
        this.queryBuilder = parentQuery;
    }

    public HasParentQueryBuilder scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public HasParentQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public HasParentQueryBuilder scoreType(String scoreType) {
        this.scoreType = scoreType;
        return this;
    }

    public HasParentQueryBuilder executionType(String executionType) {
        this.executionType = executionType;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("has_parent");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params2);
        builder.field("parent_type", this.parentType);
        if (this.scope != null) {
            builder.field("_scope", this.scope);
        }
        if (this.scoreType != null) {
            builder.field("score_type", this.scoreType);
        }
        if (this.executionType != null) {
            builder.field("execution_type", this.executionType);
        }
        if (this.boost != 1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

