/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterClause;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.child.HasParentFilter;
import org.elasticsearch.index.search.child.ParentQuery;
import org.elasticsearch.search.internal.SearchContext;

public class HasParentQueryParser
implements QueryParser {
    public static final String NAME = "has_parent";

    @Inject
    public HasParentQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query innerQuery = null;
        boolean queryFound = false;
        float boost = 1.0f;
        String parentType = null;
        String scope = null;
        boolean score = false;
        String executionType = "uid";
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    String[] stringArray;
                    if (parentType == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = parentType;
                    }
                    String[] origTypes = QueryParseContext.setTypesWithPrevious(stringArray);
                    try {
                        innerQuery = parseContext.parseInnerQuery();
                        queryFound = true;
                        continue;
                    }
                    finally {
                        QueryParseContext.setTypes(origTypes);
                        continue;
                    }
                }
                throw new QueryParsingException(parseContext.index(), "[has_parent] query does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("type".equals(currentFieldName) || "parent_type".equals(currentFieldName) || "parentType".equals(currentFieldName)) {
                parentType = parser.text();
                continue;
            }
            if ("_scope".equals(currentFieldName)) {
                scope = parser.text();
                continue;
            }
            if ("execution_type".equals(currentFieldName) || "executionType".equals(currentFieldName)) {
                executionType = parser.text();
                continue;
            }
            if ("score_type".equals(currentFieldName) || "scoreType".equals(currentFieldName)) {
                String scoreTypeValue = parser.text();
                if ("score".equals(scoreTypeValue)) {
                    score = true;
                    continue;
                }
                if (!"none".equals(scoreTypeValue)) continue;
                score = false;
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[has_parent] query does not support [" + currentFieldName + "]");
        }
        if (!queryFound) {
            throw new QueryParsingException(parseContext.index(), "[parent] query requires 'query' field");
        }
        if (innerQuery == null) {
            return null;
        }
        if (parentType == null) {
            throw new QueryParsingException(parseContext.index(), "[parent] query requires 'parent_type' field");
        }
        DocumentMapper parentDocMapper = parseContext.mapperService().documentMapper(parentType);
        if (parentDocMapper == null) {
            throw new QueryParsingException(parseContext.index(), "[parent] query configured 'parent_type' [" + parentType + "] is not a valid type");
        }
        ArrayList<String> childTypes = new ArrayList<String>(2);
        for (DocumentMapper documentMapper : parseContext.mapperService()) {
            ParentFieldMapper parentFieldMapper = documentMapper.parentFieldMapper();
            if (parentFieldMapper == null || !parentDocMapper.type().equals(parentFieldMapper.type())) continue;
            childTypes.add(documentMapper.type());
        }
        innerQuery.setBoost(boost);
        innerQuery = new FilteredQuery(innerQuery, parseContext.cacheFilter(parentDocMapper.typeFilter(), null));
        SearchContext searchContext = SearchContext.current();
        if (score) {
            Filter childFilter;
            if (childTypes.size() == 1) {
                DocumentMapper documentMapper = parseContext.mapperService().documentMapper((String)childTypes.get(0));
                childFilter = parseContext.cacheFilter(documentMapper.typeFilter(), null);
            } else {
                XBooleanFilter childrenFilter = new XBooleanFilter();
                for (String childType : childTypes) {
                    DocumentMapper documentMapper = parseContext.mapperService().documentMapper(childType);
                    Filter filter = parseContext.cacheFilter(documentMapper.typeFilter(), null);
                    childrenFilter.add(new FilterClause(filter, BooleanClause.Occur.SHOULD));
                }
                childFilter = childrenFilter;
            }
            ParentQuery parentQuery = new ParentQuery(searchContext, innerQuery, parentType, childTypes, childFilter, scope);
            searchContext.addScopePhase(parentQuery);
            query = parentQuery;
        } else {
            HasParentFilter hasParentFilter = HasParentFilter.create(executionType, innerQuery, scope, parentType, searchContext);
            searchContext.addScopePhase(hasParentFilter);
            query = new ConstantScoreQuery(hasParentFilter);
        }
        query.setBoost(boost);
        return query;
    }
}

