/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.MoreLikeThisQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class MoreLikeThisQueryParser
implements QueryParser {
    public static final String NAME = "mlt";

    @Inject
    public MoreLikeThisQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "more_like_this", "moreLikeThis"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        MoreLikeThisQuery mltQuery = new MoreLikeThisQuery();
        mltQuery.setMoreLikeFields(new String[]{parseContext.defaultField()});
        mltQuery.setSimilarity(parseContext.searchSimilarity());
        Analyzer analyzer = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("like_text".equals(currentFieldName) || "likeText".equals(currentFieldName)) {
                    mltQuery.setLikeText(parser.text());
                    continue;
                }
                if ("min_term_freq".equals(currentFieldName) || "minTermFreq".equals(currentFieldName)) {
                    mltQuery.setMinTermFrequency(parser.intValue());
                    continue;
                }
                if ("max_query_terms".equals(currentFieldName) || "maxQueryTerms".equals(currentFieldName)) {
                    mltQuery.setMaxQueryTerms(parser.intValue());
                    continue;
                }
                if ("min_doc_freq".equals(currentFieldName) || "minDocFreq".equals(currentFieldName)) {
                    mltQuery.setMinDocFreq(parser.intValue());
                    continue;
                }
                if ("max_doc_freq".equals(currentFieldName) || "maxDocFreq".equals(currentFieldName)) {
                    mltQuery.setMaxDocFreq(parser.intValue());
                    continue;
                }
                if ("min_word_len".equals(currentFieldName) || "minWordLen".equals(currentFieldName)) {
                    mltQuery.setMinWordLen(parser.intValue());
                    continue;
                }
                if ("max_word_len".equals(currentFieldName) || "maxWordLen".equals(currentFieldName)) {
                    mltQuery.setMaxWordLen(parser.intValue());
                    continue;
                }
                if ("boost_terms".equals(currentFieldName) || "boostTerms".equals(currentFieldName)) {
                    mltQuery.setBoostTerms(true);
                    mltQuery.setBoostTermsFactor(parser.floatValue());
                    continue;
                }
                if ("percent_terms_to_match".equals(currentFieldName) || "percentTermsToMatch".equals(currentFieldName)) {
                    mltQuery.setPercentTermsToMatch(parser.floatValue());
                    continue;
                }
                if ("analyzer".equals(currentFieldName)) {
                    analyzer = parseContext.analysisService().analyzer(parser.text());
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    mltQuery.setBoost(parser.floatValue());
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[mlt] query does not support [" + currentFieldName + "]");
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            if ("stop_words".equals(currentFieldName) || "stopWords".equals(currentFieldName)) {
                HashSet<String> stopWords = Sets.newHashSet();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    stopWords.add(parser.text());
                }
                mltQuery.setStopWords(stopWords);
                continue;
            }
            if ("fields".equals(currentFieldName)) {
                ArrayList<String> fields2 = Lists.newArrayList();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    fields2.add(parseContext.indexName(parser.text()));
                }
                mltQuery.setMoreLikeFields(fields2.toArray(new String[fields2.size()]));
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[mlt] query does not support [" + currentFieldName + "]");
        }
        if (mltQuery.getLikeText() == null) {
            throw new QueryParsingException(parseContext.index(), "more_like_this requires 'like_text' to be specified");
        }
        if (mltQuery.getMoreLikeFields() == null || mltQuery.getMoreLikeFields().length == 0) {
            throw new QueryParsingException(parseContext.index(), "more_like_this requires 'fields' to be specified");
        }
        if (analyzer == null) {
            analyzer = parseContext.mapperService().searchAnalyzer();
        }
        mltQuery.setAnalyzer(analyzer);
        return mltQuery;
    }
}

