/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.trove.map.hash.TObjectFloatHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;

public class MultiMatchQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<MultiMatchQueryBuilder> {
    private final Object text;
    private final List<String> fields = Lists.newArrayList();
    private TObjectFloatHashMap<String> fieldsBoosts;
    private MatchQueryBuilder.Type type;
    private MatchQueryBuilder.Operator operator;
    private String analyzer;
    private Float boost;
    private Integer slop;
    private String fuzziness;
    private Integer prefixLength;
    private Integer maxExpansions;
    private String minimumShouldMatch;
    private String rewrite = null;
    private String fuzzyRewrite = null;
    private Boolean useDisMax;
    private Integer tieBreaker;
    private Boolean lenient;

    public MultiMatchQueryBuilder(Object text, String ... fields2) {
        this.fields.addAll(Arrays.asList(fields2));
        this.text = text;
    }

    public MultiMatchQueryBuilder field(String field2) {
        this.fields.add(field2);
        return this;
    }

    public MultiMatchQueryBuilder field(String field2, float boost) {
        this.fields.add(field2);
        if (this.fieldsBoosts == null) {
            this.fieldsBoosts = new TObjectFloatHashMap(10, 0.5f, -1.0f);
        }
        this.fieldsBoosts.put(field2, boost);
        return this;
    }

    public MultiMatchQueryBuilder type(MatchQueryBuilder.Type type2) {
        this.type = type2;
        return this;
    }

    public MultiMatchQueryBuilder operator(MatchQueryBuilder.Operator operator) {
        this.operator = operator;
        return this;
    }

    public MultiMatchQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Override
    public MultiMatchQueryBuilder boost(float boost) {
        this.boost = Float.valueOf(boost);
        return this;
    }

    public MultiMatchQueryBuilder slop(int slop) {
        this.slop = slop;
        return this;
    }

    public MultiMatchQueryBuilder fuzziness(Object fuzziness) {
        this.fuzziness = fuzziness.toString();
        return this;
    }

    public MultiMatchQueryBuilder prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public MultiMatchQueryBuilder maxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
        return this;
    }

    public MultiMatchQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public MultiMatchQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public MultiMatchQueryBuilder fuzzyRewrite(String fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
        return this;
    }

    public MultiMatchQueryBuilder useDisMax(Boolean useDisMax) {
        this.useDisMax = useDisMax;
        return this;
    }

    public MultiMatchQueryBuilder tieBreaker(Integer tieBreaker) {
        this.tieBreaker = tieBreaker;
        return this;
    }

    public MultiMatchQueryBuilder lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("multi_match");
        builder.field("query", this.text);
        builder.startArray("fields");
        for (String field2 : this.fields) {
            float boost = -1.0f;
            if (this.fieldsBoosts != null) {
                boost = this.fieldsBoosts.get(field2);
            }
            if (boost != -1.0f) {
                field2 = field2 + "^" + boost;
            }
            builder.value(field2);
        }
        builder.endArray();
        if (this.type != null) {
            builder.field("type", this.type.toString().toLowerCase(Locale.ENGLISH));
        }
        if (this.operator != null) {
            builder.field("operator", this.operator.toString());
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.boost != null) {
            builder.field("boost", this.boost);
        }
        if (this.slop != null) {
            builder.field("slop", this.slop);
        }
        if (this.fuzziness != null) {
            builder.field("fuzziness", this.fuzziness);
        }
        if (this.prefixLength != null) {
            builder.field("prefix_length", this.prefixLength);
        }
        if (this.maxExpansions != null) {
            builder.field("max_expansions", this.maxExpansions);
        }
        if (this.minimumShouldMatch != null) {
            builder.field("minimum_should_match", this.minimumShouldMatch);
        }
        if (this.rewrite != null) {
            builder.field("rewrite", this.rewrite);
        }
        if (this.fuzzyRewrite != null) {
            builder.field("fuzzy_rewrite", this.fuzzyRewrite);
        }
        if (this.useDisMax != null) {
            builder.field("use_dis_max", (Object)this.useDisMax);
        }
        if (this.tieBreaker != null) {
            builder.field("tie_breaker", this.tieBreaker);
        }
        if (this.lenient != null) {
            builder.field("lenient", (Object)this.lenient);
        }
        builder.endObject();
    }
}

