/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.docset.GetDocSet;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;

public class ScriptFilterParser
implements FilterParser {
    public static final String NAME = "script";

    @Inject
    public ScriptFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String script = null;
        String scriptLang = null;
        Map<String, Object> params2 = null;
        String filterName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("params".equals(currentFieldName)) {
                    params2 = parser.map();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[script] filter does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if (NAME.equals(currentFieldName)) {
                script = parser.text();
                continue;
            }
            if ("lang".equals(currentFieldName)) {
                scriptLang = parser.text();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if ("_cache_key".equals(currentFieldName) || "_cacheKey".equals(currentFieldName)) {
                cacheKey = new CacheKeyFilter.Key(parser.text());
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[script] filter does not support [" + currentFieldName + "]");
        }
        if (script == null) {
            throw new QueryParsingException(parseContext.index(), "script must be provided with a [script] filter");
        }
        if (params2 == null) {
            params2 = Maps.newHashMap();
        }
        Filter filter = new ScriptFilter(scriptLang, script, params2, parseContext.scriptService(), parseContext.lookup());
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }

    public static class ScriptFilter
    extends Filter {
        private final String script;
        private final Map<String, Object> params;
        private final SearchScript searchScript;

        public ScriptFilter(String scriptLang, String script, Map<String, Object> params2, ScriptService scriptService, SearchLookup searchLookup) {
            this.script = script;
            this.params = params2;
            this.searchScript = scriptService.search(searchLookup, scriptLang, script, Maps.newHashMap(params2));
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("ScriptFilter(");
            buffer.append(this.script);
            buffer.append(")");
            return buffer.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScriptFilter that = (ScriptFilter)o;
            if (this.params != null ? !((Object)this.params).equals(that.params) : that.params != null) {
                return false;
            }
            return !(this.script != null ? !this.script.equals(that.script) : that.script != null);
        }

        public int hashCode() {
            int result2 = this.script != null ? this.script.hashCode() : 0;
            result2 = 31 * result2 + (this.params != null ? ((Object)this.params).hashCode() : 0);
            return result2;
        }

        @Override
        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            this.searchScript.setNextReader(reader);
            return new ScriptDocSet(reader, this.searchScript);
        }

        static class ScriptDocSet
        extends GetDocSet {
            private final SearchScript searchScript;

            public ScriptDocSet(IndexReader reader, SearchScript searchScript) {
                super(reader.maxDoc());
                this.searchScript = searchScript;
            }

            @Override
            public long sizeInBytes() {
                return 0L;
            }

            @Override
            public boolean isCacheable() {
                return false;
            }

            @Override
            public boolean get(int doc) {
                this.searchScript.setNextDocId(doc);
                Object val = this.searchScript.run();
                if (val == null) {
                    return false;
                }
                if (val instanceof Boolean) {
                    return (Boolean)val;
                }
                if (val instanceof Number) {
                    return ((Number)val).longValue() != 0L;
                }
                throw new ElasticSearchIllegalArgumentException("Can't handle type [" + val + "] in script filter");
            }
        }
    }
}

