/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilderException;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanNotQueryBuilder
extends BaseQueryBuilder
implements SpanQueryBuilder,
BoostableQueryBuilder<SpanNotQueryBuilder> {
    private SpanQueryBuilder include;
    private SpanQueryBuilder exclude;
    private float boost = -1.0f;

    public SpanNotQueryBuilder include(SpanQueryBuilder include2) {
        this.include = include2;
        return this;
    }

    public SpanNotQueryBuilder exclude(SpanQueryBuilder exclude) {
        this.exclude = exclude;
        return this;
    }

    @Override
    public SpanNotQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        if (this.include == null) {
            throw new QueryBuilderException("Must specify include when using spanNot query");
        }
        if (this.exclude == null) {
            throw new QueryBuilderException("Must specify exclude when using spanNot query");
        }
        builder.startObject("span_not");
        builder.field("include");
        this.include.toXContent(builder, params2);
        builder.field("exclude");
        this.exclude.toXContent(builder, params2);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

