/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class SpanNotQueryParser
implements QueryParser {
    public static final String NAME = "span_not";

    @Inject
    public SpanNotQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        SpanQuery include2 = null;
        SpanQuery exclude = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("include".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    if (!(query instanceof SpanQuery)) {
                        throw new QueryParsingException(parseContext.index(), "spanNot [include] must be of type span query");
                    }
                    include2 = query;
                    continue;
                }
                if ("exclude".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    if (!(query instanceof SpanQuery)) {
                        throw new QueryParsingException(parseContext.index(), "spanNot [exclude] must be of type span query");
                    }
                    exclude = query;
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[span_not] query does not support [" + currentFieldName + "]");
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[span_not] query does not support [" + currentFieldName + "]");
        }
        if (include2 == null) {
            throw new QueryParsingException(parseContext.index(), "spanNot must have [include] span query clause");
        }
        if (exclude == null) {
            throw new QueryParsingException(parseContext.index(), "spanNot must have [exclude] span query clause");
        }
        query = new SpanNotQuery(include2, exclude);
        query.setBoost(boost);
        return query;
    }
}

