/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class TermsQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<TermsQueryBuilder> {
    private final String name;
    private final Object[] values;
    private String minimumShouldMatch;
    private Boolean disableCoord;
    private float boost = -1.0f;

    public TermsQueryBuilder(String name2, String ... values2) {
        this(name2, (Object[])values2);
    }

    public TermsQueryBuilder(String name2, int ... values2) {
        this.name = name2;
        this.values = new Integer[values2.length];
        for (int i2 = 0; i2 < values2.length; ++i2) {
            this.values[i2] = values2[i2];
        }
    }

    public TermsQueryBuilder(String name2, long ... values2) {
        this.name = name2;
        this.values = new Long[values2.length];
        for (int i2 = 0; i2 < values2.length; ++i2) {
            this.values[i2] = values2[i2];
        }
    }

    public TermsQueryBuilder(String name2, float ... values2) {
        this.name = name2;
        this.values = new Float[values2.length];
        for (int i2 = 0; i2 < values2.length; ++i2) {
            this.values[i2] = Float.valueOf(values2[i2]);
        }
    }

    public TermsQueryBuilder(String name2, double ... values2) {
        this.name = name2;
        this.values = new Double[values2.length];
        for (int i2 = 0; i2 < values2.length; ++i2) {
            this.values[i2] = values2[i2];
        }
    }

    public TermsQueryBuilder(String name2, Object ... values2) {
        this.name = name2;
        this.values = values2;
    }

    public TermsQueryBuilder minimumMatch(int minimumMatch) {
        this.minimumShouldMatch = Integer.toString(minimumMatch);
        return this;
    }

    public TermsQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    @Override
    public TermsQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public TermsQueryBuilder disableCoord(boolean disableCoord) {
        this.disableCoord = disableCoord;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("terms");
        builder.startArray(this.name);
        for (Object value2 : this.values) {
            builder.value(value2);
        }
        builder.endArray();
        if (this.minimumShouldMatch != null) {
            builder.field("minimum_should_match", this.minimumShouldMatch);
        }
        if (this.disableCoord != null) {
            builder.field("disable_coord", (Object)this.disableCoord);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

