/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class TermsQueryParser
implements QueryParser {
    public static final String NAME = "terms";

    @Inject
    public TermsQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "in"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        block18: {
            XContentParser.Token token;
            XContentParser parser = parseContext.parser();
            String fieldName = null;
            boolean disableCoord = false;
            float boost = 1.0f;
            String minimumShouldMatch = null;
            ArrayList<String> values2 = Lists.newArrayList();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    fieldName = currentFieldName;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String value2 = parser.text();
                        if (value2 == null) {
                            throw new QueryParsingException(parseContext.index(), "No value specified for terms query");
                        }
                        values2.add(value2);
                    }
                    continue;
                }
                if (token.isValue()) {
                    if ("disable_coord".equals(currentFieldName) || "disableCoord".equals(currentFieldName)) {
                        disableCoord = parser.booleanValue();
                        continue;
                    }
                    if ("minimum_match".equals(currentFieldName) || "minimumMatch".equals(currentFieldName)) {
                        minimumShouldMatch = parser.textOrNull();
                        continue;
                    }
                    if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                        minimumShouldMatch = parser.textOrNull();
                        continue;
                    }
                    if ("boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[terms] query does not support [" + currentFieldName + "]");
                }
                throw new QueryParsingException(parseContext.index(), "[terms] query does not support [" + currentFieldName + "]");
            }
            if (fieldName == null) {
                throw new QueryParsingException(parseContext.index(), "No field specified for terms query");
            }
            FieldMapper mapper = null;
            MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
            String[] previousTypes = null;
            if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
                mapper = smartNameFieldMappers.mapper();
                if (smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                    previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{smartNameFieldMappers.docMapper().type()});
                }
            }
            try {
                BooleanQuery query2 = new BooleanQuery(disableCoord);
                for (String value3 : values2) {
                    if (mapper != null) {
                        query2.add(new BooleanClause(mapper.fieldQuery(value3, parseContext), BooleanClause.Occur.SHOULD));
                        continue;
                    }
                    query2.add(new TermQuery(new Term(fieldName, value3)), BooleanClause.Occur.SHOULD);
                }
                query2.setBoost(boost);
                Queries.applyMinimumShouldMatch(query2, minimumShouldMatch);
                query = QueryParsers.wrapSmartNameQuery(Queries.optimizeQuery(Queries.fixNegativeQueryIfNeeded(query2)), smartNameFieldMappers, parseContext);
                if (smartNameFieldMappers == null || !smartNameFieldMappers.explicitTypeInNameWithDocMapper()) break block18;
            }
            catch (Throwable throwable) {
                if (smartNameFieldMappers != null && smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                    QueryParseContext.setTypes(previousTypes);
                }
                throw throwable;
            }
            QueryParseContext.setTypes(previousTypes);
        }
        return query;
    }
}

