/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.trove.map.TObjectFloatMap;
import org.elasticsearch.common.trove.map.TObjectIntMap;
import org.elasticsearch.common.trove.map.hash.TObjectFloatHashMap;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.index.search.child.ParentIdCollector;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.internal.ScopePhase;
import org.elasticsearch.search.internal.SearchContext;

public class ChildrenQuery
extends Query
implements ScopePhase.CollectorPhase {
    private final SearchContext searchContext;
    private final String parentType;
    private final String childType;
    private final Filter parentFilter;
    private final ScoreType scoreType;
    private final String scope;
    private final Query childQuery;
    private TObjectFloatHashMap<HashedBytesArray> uidToScore;
    private TObjectIntHashMap<HashedBytesArray> uidToCount;

    public ChildrenQuery(SearchContext searchContext, String parentType, String childType, Filter parentFilter, String scope, Query childQuery, ScoreType scoreType) {
        this.searchContext = searchContext;
        this.parentType = parentType;
        this.childType = childType;
        this.parentFilter = parentFilter;
        this.scope = scope;
        this.childQuery = childQuery;
        this.scoreType = scoreType;
    }

    private ChildrenQuery(ChildrenQuery unProcessedQuery, Query rewrittenChildQuery) {
        this.searchContext = unProcessedQuery.searchContext;
        this.parentType = unProcessedQuery.parentType;
        this.childType = unProcessedQuery.childType;
        this.parentFilter = unProcessedQuery.parentFilter;
        this.scope = unProcessedQuery.scope;
        this.scoreType = unProcessedQuery.scoreType;
        this.childQuery = rewrittenChildQuery;
        this.uidToScore = unProcessedQuery.uidToScore;
        this.uidToCount = unProcessedQuery.uidToCount;
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append("ChildrenQuery[").append(this.childType).append("/").append(this.parentType).append("](").append(this.childQuery.toString(field2)).append(')').append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewrittenChildQuery = this.childQuery.rewrite(reader);
        if (rewrittenChildQuery == this.childQuery) {
            return this;
        }
        int index2 = this.searchContext.scopePhases().indexOf(this);
        ChildrenQuery rewrite = new ChildrenQuery(this, rewrittenChildQuery);
        this.searchContext.scopePhases().set(index2, rewrite);
        return rewrite;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.childQuery.extractTerms(terms);
    }

    @Override
    public boolean requiresProcessing() {
        return this.uidToScore == null;
    }

    @Override
    public Collector collector() {
        this.uidToScore = CacheRecycler.popObjectFloatMap();
        switch (this.scoreType) {
            case AVG: {
                this.uidToCount = CacheRecycler.popObjectIntMap();
                return new AvgChildUidCollector(this.scoreType, this.searchContext, this.parentType, this.uidToScore, this.uidToCount);
            }
        }
        return new ChildUidCollector(this.scoreType, this.searchContext, this.parentType, this.uidToScore);
    }

    @Override
    public void processCollector(Collector collector) {
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public void clear() {
        if (this.uidToScore != null) {
            CacheRecycler.pushObjectFloatMap(this.uidToScore);
        }
        this.uidToScore = null;
        if (this.uidToCount != null) {
            CacheRecycler.pushObjectIntMap(this.uidToCount);
        }
        this.uidToCount = null;
    }

    @Override
    public Query query() {
        return this.childQuery;
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        if (this.uidToScore == null) {
            throw new ElasticSearchIllegalStateException("has_child query hasn't executed properly");
        }
        return new ParentWeight(this.childQuery.createWeight(searcher));
    }

    static final class AvgChildUidCollector
    extends ChildUidCollector {
        final TObjectIntHashMap<HashedBytesArray> uidToCount;

        AvgChildUidCollector(ScoreType scoreType, SearchContext searchContext, String childType, TObjectFloatHashMap<HashedBytesArray> uidToScore, TObjectIntHashMap<HashedBytesArray> uidToCount) {
            super(scoreType, searchContext, childType, uidToScore);
            this.uidToCount = uidToCount;
            assert (scoreType == ScoreType.AVG);
        }

        @Override
        protected void collect(int doc, HashedBytesArray parentUid) throws IOException {
            float previousScore = this.uidToScore.get(parentUid);
            float currentScore = this.scorer.score();
            if (Float.compare(previousScore, 0.0f) == 0) {
                this.uidToScore.put(parentUid, currentScore);
                this.uidToCount.put(parentUid, 1);
            } else {
                this.uidToScore.adjustValue(parentUid, currentScore);
                this.uidToCount.increment(parentUid);
            }
        }
    }

    static class ChildUidCollector
    extends ParentIdCollector {
        final TObjectFloatHashMap<HashedBytesArray> uidToScore;
        final ScoreType scoreType;
        Scorer scorer;

        ChildUidCollector(ScoreType scoreType, SearchContext searchContext, String childType, TObjectFloatHashMap<HashedBytesArray> uidToScore) {
            super(childType, searchContext);
            this.uidToScore = uidToScore;
            this.scoreType = scoreType;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        protected void collect(int doc, HashedBytesArray parentUid) throws IOException {
            float previousScore = this.uidToScore.get(parentUid);
            float currentScore = this.scorer.score();
            if (Float.compare(previousScore, 0.0f) == 0) {
                this.uidToScore.put(parentUid, currentScore);
            } else {
                switch (this.scoreType) {
                    case SUM: {
                        this.uidToScore.adjustValue(parentUid, currentScore);
                        break;
                    }
                    case MAX: {
                        if (Float.compare(previousScore, currentScore) >= 0) break;
                        this.uidToScore.put(parentUid, currentScore);
                        break;
                    }
                    case AVG: {
                        assert (false) : "AVG has it's own collector";
                    }
                    default: {
                        assert (false) : "Are we missing a sore type here? -- " + (Object)((Object)this.scoreType);
                        break;
                    }
                }
            }
        }
    }

    static class AvgParentScorer
    extends ParentScorer {
        final TObjectIntMap<HashedBytesArray> uidToCount;
        HashedBytesArray currentUid;

        AvgParentScorer(Weight weight, IdReaderTypeCache idTypeCache, TObjectFloatMap<HashedBytesArray> uidToScore, TObjectIntMap<HashedBytesArray> uidToCount, DocIdSetIterator parentsIterator) {
            super(weight, idTypeCache, uidToScore, parentsIterator);
            this.uidToCount = uidToCount;
        }

        @Override
        public int nextDoc() throws IOException {
            do {
                this.currentDocId = this.parentsIterator.nextDoc();
                if (this.currentDocId == Integer.MAX_VALUE) {
                    return this.currentDocId;
                }
                this.currentUid = this.idTypeCache.idByDoc(this.currentDocId);
                this.currentScore = this.uidToScore.get(this.currentUid);
            } while (Float.compare(this.currentScore, 0.0f) <= 0);
            this.currentScore /= (float)this.uidToCount.get(this.currentUid);
            return this.currentDocId;
        }

        @Override
        public int advance(int target) throws IOException {
            this.currentDocId = this.parentsIterator.advance(target);
            if (this.currentDocId == Integer.MAX_VALUE) {
                return this.currentDocId;
            }
            HashedBytesArray uid2 = this.idTypeCache.idByDoc(this.currentDocId);
            this.currentScore = this.uidToScore.get(uid2);
            if (Float.compare(this.currentScore, 0.0f) > 0) {
                this.currentScore /= (float)this.uidToCount.get(this.currentUid);
                return this.currentDocId;
            }
            return this.nextDoc();
        }
    }

    static class ParentScorer
    extends Scorer {
        final IdReaderTypeCache idTypeCache;
        final TObjectFloatMap<HashedBytesArray> uidToScore;
        final DocIdSetIterator parentsIterator;
        int currentDocId = -1;
        float currentScore;

        ParentScorer(Weight weight, IdReaderTypeCache idTypeCache, TObjectFloatMap<HashedBytesArray> uidToScore, DocIdSetIterator parentsIterator) {
            super(weight);
            this.idTypeCache = idTypeCache;
            this.uidToScore = uidToScore;
            this.parentsIterator = parentsIterator;
        }

        @Override
        public float score() throws IOException {
            return this.currentScore;
        }

        @Override
        public float freq() throws IOException {
            return 1.0f;
        }

        @Override
        public int docID() {
            return this.currentDocId;
        }

        @Override
        public int nextDoc() throws IOException {
            do {
                this.currentDocId = this.parentsIterator.nextDoc();
                if (this.currentDocId == Integer.MAX_VALUE) {
                    return this.currentDocId;
                }
                HashedBytesArray uid2 = this.idTypeCache.idByDoc(this.currentDocId);
                this.currentScore = this.uidToScore.get(uid2);
            } while (Float.compare(this.currentScore, 0.0f) <= 0);
            return this.currentDocId;
        }

        @Override
        public int advance(int target) throws IOException {
            this.currentDocId = this.parentsIterator.advance(target);
            if (this.currentDocId == Integer.MAX_VALUE) {
                return this.currentDocId;
            }
            HashedBytesArray uid2 = this.idTypeCache.idByDoc(this.currentDocId);
            this.currentScore = this.uidToScore.get(uid2);
            if (Float.compare(this.currentScore, 0.0f) > 0) {
                return this.currentDocId;
            }
            return this.nextDoc();
        }
    }

    class ParentWeight
    extends Weight {
        final Weight childWeight;

        public ParentWeight(Weight childWeight) {
            this.childWeight = childWeight;
        }

        @Override
        public Query getQuery() {
            return ChildrenQuery.this;
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation(ChildrenQuery.this.getBoost(), "not implemented yet...");
        }

        @Override
        public float getValue() {
            return ChildrenQuery.this.getBoost();
        }

        @Override
        public void normalize(float norm) {
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            float sum2 = this.childWeight.sumOfSquaredWeights();
            return sum2 *= ChildrenQuery.this.getBoost() * ChildrenQuery.this.getBoost();
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            DocIdSet parentsSet = ChildrenQuery.this.parentFilter.getDocIdSet(reader);
            if (parentsSet == null || parentsSet == DocIdSet.EMPTY_DOCIDSET) {
                return null;
            }
            IdReaderTypeCache idTypeCache = ChildrenQuery.this.searchContext.idCache().reader(reader).type(ChildrenQuery.this.parentType);
            DocIdSetIterator parentsIterator = parentsSet.iterator();
            switch (ChildrenQuery.this.scoreType) {
                case AVG: {
                    return new AvgParentScorer(this, idTypeCache, ChildrenQuery.this.uidToScore, ChildrenQuery.this.uidToCount, parentsIterator);
                }
            }
            return new ParentScorer(this, idTypeCache, ChildrenQuery.this.uidToScore, parentsIterator);
        }
    }
}

