/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.lucene.docset.GetDocSet;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.trove.set.hash.THashSet;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.search.internal.ScopePhase;
import org.elasticsearch.search.internal.SearchContext;

public abstract class HasParentFilter
extends Filter
implements ScopePhase.CollectorPhase {
    final Query parentQuery;
    final String scope;
    final String parentType;
    final SearchContext context;

    HasParentFilter(Query parentQuery, String scope, String parentType, SearchContext context) {
        this.parentQuery = parentQuery;
        this.scope = scope;
        this.parentType = parentType;
        this.context = context;
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public Query query() {
        return this.parentQuery;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("parent_filter[").append(this.parentType).append("](").append(this.query()).append(')');
        return sb.toString();
    }

    public static HasParentFilter create(String executionType, Query query, String scope, String parentType, SearchContext context) {
        if ("bitset".equals(executionType)) {
            return new Bitset(query, scope, parentType, context);
        }
        if ("uid".equals(executionType)) {
            return new Uid(query, scope, parentType, context);
        }
        throw new ElasticSearchIllegalStateException("Illegal has_parent execution type: " + executionType);
    }

    static class Bitset
    extends HasParentFilter {
        Map<Object, FixedBitSet> parentDocs;

        Bitset(Query query, String scope, String parentType, SearchContext context) {
            super(query, scope, parentType, context);
        }

        @Override
        public boolean requiresProcessing() {
            return this.parentDocs == null;
        }

        @Override
        public Collector collector() {
            return new ParentDocsCollector();
        }

        @Override
        public void processCollector(Collector collector) {
            this.parentDocs = ((ParentDocsCollector)collector).segmentResults;
        }

        @Override
        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            if (this.parentDocs == null) {
                throw new ElasticSearchIllegalStateException("has_parent filter hasn't executed properly");
            }
            IdReaderTypeCache currentTypeCache = this.context.idCache().reader(reader).type(this.parentType);
            if (currentTypeCache == null) {
                return null;
            }
            return new ChildrenDocSet(reader, currentTypeCache, this.parentDocs, this.context, this.parentType);
        }

        @Override
        public void clear() {
            this.parentDocs = null;
        }

        static class ParentDocsCollector
        extends NoopCollector {
            final Map<Object, FixedBitSet> segmentResults = Maps.newHashMap();
            FixedBitSet current;

            ParentDocsCollector() {
            }

            @Override
            public void collect(int doc) throws IOException {
                this.current.set(doc);
            }

            @Override
            public void setNextReader(IndexReader reader, int docBase) throws IOException {
                this.current = new FixedBitSet(reader.maxDoc());
                this.segmentResults.put(reader.getCoreCacheKey(), this.current);
            }
        }

        static class ChildrenDocSet
        extends GetDocSet {
            final IdReaderTypeCache currentTypeCache;
            final IndexReader currentReader;
            final Tuple<IndexReader, IdReaderTypeCache>[] readersToTypeCache;
            final Map<Object, FixedBitSet> parentDocs;

            ChildrenDocSet(IndexReader currentReader, IdReaderTypeCache currentTypeCache, Map<Object, FixedBitSet> parentDocs, SearchContext context, String parentType) {
                super(currentReader.maxDoc());
                this.currentTypeCache = currentTypeCache;
                this.currentReader = currentReader;
                this.parentDocs = parentDocs;
                this.readersToTypeCache = new Tuple[context.searcher().subReaders().length];
                for (int i2 = 0; i2 < this.readersToTypeCache.length; ++i2) {
                    IndexReader reader = context.searcher().subReaders()[i2];
                    this.readersToTypeCache[i2] = new Tuple<IndexReader, IdReaderTypeCache>(reader, context.idCache().reader(reader).type(parentType));
                }
            }

            @Override
            public boolean get(int doc) {
                if (this.currentReader.isDeleted(doc) || doc == -1) {
                    return false;
                }
                HashedBytesArray parentId = this.currentTypeCache.parentIdByDoc(doc);
                if (parentId == null) {
                    return false;
                }
                for (Tuple<IndexReader, IdReaderTypeCache> readerTypeCacheTuple : this.readersToTypeCache) {
                    FixedBitSet currentParentDocs;
                    int parentDocId = readerTypeCacheTuple.v2().docById(parentId);
                    if (parentDocId == -1 || !(currentParentDocs = this.parentDocs.get(readerTypeCacheTuple.v1().getCoreCacheKey())).get(parentDocId)) continue;
                    return true;
                }
                return false;
            }
        }
    }

    static class Uid
    extends HasParentFilter {
        THashSet<HashedBytesArray> parents;

        Uid(Query query, String scope, String parentType, SearchContext context) {
            super(query, scope, parentType, context);
        }

        @Override
        public boolean requiresProcessing() {
            return this.parents == null;
        }

        @Override
        public Collector collector() {
            this.parents = CacheRecycler.popHashSet();
            return new ParentUidsCollector(this.parents, this.context, this.parentType);
        }

        @Override
        public void processCollector(Collector collector) {
            this.parents = ((ParentUidsCollector)collector).collectedUids;
        }

        @Override
        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            if (this.parents == null) {
                throw new ElasticSearchIllegalStateException("has_parent filter hasn't executed properly");
            }
            IdReaderTypeCache idReaderTypeCache = this.context.idCache().reader(reader).type(this.parentType);
            if (idReaderTypeCache != null) {
                return new ChildrenDocSet(reader, this.parents, idReaderTypeCache);
            }
            return null;
        }

        @Override
        public void clear() {
            if (this.parents != null) {
                CacheRecycler.pushHashSet(this.parents);
            }
            this.parents = null;
        }

        static class ParentUidsCollector
        extends NoopCollector {
            final THashSet<HashedBytesArray> collectedUids;
            final SearchContext context;
            final String parentType;
            IdReaderTypeCache typeCache;

            ParentUidsCollector(THashSet<HashedBytesArray> collectedUids, SearchContext context, String parentType) {
                this.collectedUids = collectedUids;
                this.context = context;
                this.parentType = parentType;
            }

            @Override
            public void collect(int doc) throws IOException {
                if (this.typeCache != null) {
                    this.collectedUids.add(this.typeCache.idByDoc(doc));
                }
            }

            @Override
            public void setNextReader(IndexReader reader, int docBase) throws IOException {
                this.typeCache = this.context.idCache().reader(reader).type(this.parentType);
            }
        }

        static class ChildrenDocSet
        extends GetDocSet {
            final IndexReader reader;
            final THashSet<HashedBytesArray> parents;
            final IdReaderTypeCache idReaderTypeCache;

            ChildrenDocSet(IndexReader reader, THashSet<HashedBytesArray> parents, IdReaderTypeCache idReaderTypeCache) {
                super(reader.maxDoc());
                this.reader = reader;
                this.parents = parents;
                this.idReaderTypeCache = idReaderTypeCache;
            }

            @Override
            public boolean get(int doc) {
                return !this.reader.isDeleted(doc) && this.parents.contains(this.idReaderTypeCache.parentIdByDoc(doc));
            }
        }
    }
}

