/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.lucene.docset.AndDocSet;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.common.lucene.docset.GetDocSet;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.mapper.geo.GeoPointFieldData;
import org.elasticsearch.index.mapper.geo.GeoPointFieldDataType;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.index.search.geo.IndexedGeoBoundingBoxFilter;

public class GeoDistanceFilter
extends Filter {
    private final double lat;
    private final double lon;
    private final double distance;
    private final GeoDistance geoDistance;
    private final String fieldName;
    private final FieldDataCache fieldDataCache;
    private final GeoDistance.FixedSourceDistance fixedSourceDistance;
    private GeoDistance.DistanceBoundingCheck distanceBoundingCheck;
    private final Filter boundingBoxFilter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeoDistanceFilter(double lat, double lon, double distance, GeoDistance geoDistance, String fieldName, GeoPointFieldMapper mapper, FieldDataCache fieldDataCache, String optimizeBbox) {
        this.lat = lat;
        this.lon = lon;
        this.distance = distance;
        this.geoDistance = geoDistance;
        this.fieldName = fieldName;
        this.fieldDataCache = fieldDataCache;
        this.fixedSourceDistance = geoDistance.fixedSourceDistance(lat, lon, DistanceUnit.MILES);
        if (optimizeBbox != null && !"none".equals(optimizeBbox)) {
            this.distanceBoundingCheck = GeoDistance.distanceBoundingCheck(lat, lon, distance, DistanceUnit.MILES);
            if ("memory".equals(optimizeBbox)) {
                this.boundingBoxFilter = null;
                return;
            } else {
                if (!"indexed".equals(optimizeBbox)) throw new ElasticSearchIllegalArgumentException("type [" + optimizeBbox + "] for bounding box optimization not supported");
                this.boundingBoxFilter = IndexedGeoBoundingBoxFilter.create(this.distanceBoundingCheck.topLeft(), this.distanceBoundingCheck.bottomRight(), mapper);
                this.distanceBoundingCheck = GeoDistance.ALWAYS_INSTANCE;
            }
            return;
        } else {
            this.distanceBoundingCheck = GeoDistance.ALWAYS_INSTANCE;
            this.boundingBoxFilter = null;
        }
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public double distance() {
        return this.distance;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    public String fieldName() {
        return this.fieldName;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        DocSet boundingBoxDocSet = null;
        if (this.boundingBoxFilter != null) {
            DocIdSet docIdSet = this.boundingBoxFilter.getDocIdSet(reader);
            if (docIdSet == null) {
                return null;
            }
            boundingBoxDocSet = DocSets.convert(reader, docIdSet);
        }
        GeoPointFieldData fieldData = (GeoPointFieldData)this.fieldDataCache.cache(GeoPointFieldDataType.TYPE, reader, this.fieldName);
        GeoDistanceDocSet distDocSet = new GeoDistanceDocSet(reader.maxDoc(), fieldData, this.fixedSourceDistance, this.distanceBoundingCheck, this.distance);
        if (boundingBoxDocSet == null) {
            return distDocSet;
        }
        return new AndDocSet(ImmutableList.of(boundingBoxDocSet, distDocSet));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoDistanceFilter filter = (GeoDistanceFilter)o;
        if (Double.compare(filter.distance, this.distance) != 0) {
            return false;
        }
        if (Double.compare(filter.lat, this.lat) != 0) {
            return false;
        }
        if (Double.compare(filter.lon, this.lon) != 0) {
            return false;
        }
        if (this.fieldName != null ? !this.fieldName.equals(filter.fieldName) : filter.fieldName != null) {
            return false;
        }
        return this.geoDistance == filter.geoDistance;
    }

    public String toString() {
        return "GeoDistanceFilter(" + this.fieldName + ", " + (Object)((Object)this.geoDistance) + ", " + this.distance + ", " + this.lat + ", " + this.lon + ")";
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result2 = (int)(temp ^ temp >>> 32);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = this.distance != 0.0 ? Double.doubleToLongBits(this.distance) : 0L;
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        result2 = 31 * result2 + (this.geoDistance != null ? this.geoDistance.hashCode() : 0);
        result2 = 31 * result2 + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        return result2;
    }

    public static class GeoDistanceDocSet
    extends GetDocSet {
        private final double distance;
        private final GeoPointFieldData fieldData;
        private final GeoDistance.FixedSourceDistance fixedSourceDistance;
        private final GeoDistance.DistanceBoundingCheck distanceBoundingCheck;

        public GeoDistanceDocSet(int maxDoc, GeoPointFieldData fieldData, GeoDistance.FixedSourceDistance fixedSourceDistance, GeoDistance.DistanceBoundingCheck distanceBoundingCheck, double distance) {
            super(maxDoc);
            this.fieldData = fieldData;
            this.fixedSourceDistance = fixedSourceDistance;
            this.distanceBoundingCheck = distanceBoundingCheck;
            this.distance = distance;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean get(int doc) {
            double lon;
            if (!this.fieldData.hasValue(doc)) {
                return false;
            }
            if (this.fieldData.multiValued()) {
                double[] lats = this.fieldData.latValues(doc);
                double[] lons = this.fieldData.lonValues(doc);
                for (int i2 = 0; i2 < lats.length; ++i2) {
                    double d;
                    double lat = lats[i2];
                    double lon2 = lons[i2];
                    if (!this.distanceBoundingCheck.isWithin(lat, lon2) || !((d = this.fixedSourceDistance.calculate(lat, lon2)) < this.distance)) continue;
                    return true;
                }
                return false;
            }
            double lat = this.fieldData.latValue(doc);
            if (this.distanceBoundingCheck.isWithin(lat, lon = this.fieldData.lonValue(doc))) {
                double d = this.fixedSourceDistance.calculate(lat, lon);
                return d < this.distance;
            }
            return false;
        }
    }
}

