/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.lucene.docset.GetDocSet;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.mapper.geo.GeoPointFieldData;
import org.elasticsearch.index.mapper.geo.GeoPointFieldDataType;
import org.elasticsearch.index.search.geo.Point;

public class InMemoryGeoBoundingBoxFilter
extends Filter {
    private final Point topLeft;
    private final Point bottomRight;
    private final String fieldName;
    private final FieldDataCache fieldDataCache;

    public InMemoryGeoBoundingBoxFilter(Point topLeft, Point bottomRight, String fieldName, FieldDataCache fieldDataCache) {
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
        this.fieldName = fieldName;
        this.fieldDataCache = fieldDataCache;
    }

    public Point topLeft() {
        return this.topLeft;
    }

    public Point bottomRight() {
        return this.bottomRight;
    }

    public String fieldName() {
        return this.fieldName;
    }

    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        GeoPointFieldData fieldData = (GeoPointFieldData)this.fieldDataCache.cache(GeoPointFieldDataType.TYPE, reader, this.fieldName);
        if (this.topLeft.lon > this.bottomRight.lon) {
            return new Meridian180GeoBoundingBoxDocSet(reader.maxDoc(), fieldData, this.topLeft, this.bottomRight);
        }
        return new GeoBoundingBoxDocSet(reader.maxDoc(), fieldData, this.topLeft, this.bottomRight);
    }

    public String toString() {
        return "GeoBoundingBoxFilter(" + this.fieldName + ", " + this.topLeft + ", " + this.bottomRight + ")";
    }

    public static class GeoBoundingBoxDocSet
    extends GetDocSet {
        private final GeoPointFieldData fieldData;
        private final Point topLeft;
        private final Point bottomRight;

        public GeoBoundingBoxDocSet(int maxDoc, GeoPointFieldData fieldData, Point topLeft, Point bottomRight) {
            super(maxDoc);
            this.fieldData = fieldData;
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean get(int doc) {
            if (!this.fieldData.hasValue(doc)) {
                return false;
            }
            if (this.fieldData.multiValued()) {
                double[] lats = this.fieldData.latValues(doc);
                double[] lons = this.fieldData.lonValues(doc);
                for (int i2 = 0; i2 < lats.length; ++i2) {
                    if (!(this.topLeft.lon <= lons[i2]) || !(this.bottomRight.lon >= lons[i2]) || !(this.topLeft.lat >= lats[i2]) || !(this.bottomRight.lat <= lats[i2])) continue;
                    return true;
                }
            } else {
                double lat = this.fieldData.latValue(doc);
                double lon = this.fieldData.lonValue(doc);
                if (this.topLeft.lon <= lon && this.bottomRight.lon >= lon && this.topLeft.lat >= lat && this.bottomRight.lat <= lat) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Meridian180GeoBoundingBoxDocSet
    extends GetDocSet {
        private final GeoPointFieldData fieldData;
        private final Point topLeft;
        private final Point bottomRight;

        public Meridian180GeoBoundingBoxDocSet(int maxDoc, GeoPointFieldData fieldData, Point topLeft, Point bottomRight) {
            super(maxDoc);
            this.fieldData = fieldData;
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean get(int doc) {
            if (!this.fieldData.hasValue(doc)) {
                return false;
            }
            if (this.fieldData.multiValued()) {
                double[] lats = this.fieldData.latValues(doc);
                double[] lons = this.fieldData.lonValues(doc);
                for (int i2 = 0; i2 < lats.length; ++i2) {
                    double lat = lats[i2];
                    double lon = lons[i2];
                    if (!(this.topLeft.lon <= lon) && !(this.bottomRight.lon >= lon) || !(this.topLeft.lat >= lat) || !(this.bottomRight.lat <= lat)) continue;
                    return true;
                }
            } else {
                double lat = this.fieldData.latValue(doc);
                double lon = this.fieldData.lonValue(doc);
                if ((this.topLeft.lon <= lon || this.bottomRight.lon >= lon) && this.topLeft.lat >= lat && this.bottomRight.lat <= lat) {
                    return true;
                }
            }
            return false;
        }
    }
}

