/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.nested;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.docset.FixedBitDocSet;

public class IncludeNestedDocsQuery
extends Query {
    private final Filter parentFilter;
    private final Query parentQuery;
    private final Query origParentQuery;

    public IncludeNestedDocsQuery(Query parentQuery, Filter parentFilter) {
        this.origParentQuery = parentQuery;
        this.parentQuery = parentQuery;
        this.parentFilter = parentFilter;
    }

    IncludeNestedDocsQuery(Query rewrite, Query originalQuery, IncludeNestedDocsQuery previousInstance) {
        this.origParentQuery = originalQuery;
        this.parentQuery = rewrite;
        this.parentFilter = previousInstance.parentFilter;
        this.setBoost(previousInstance.getBoost());
    }

    IncludeNestedDocsQuery(Query originalQuery, IncludeNestedDocsQuery previousInstance) {
        this.origParentQuery = originalQuery;
        this.parentQuery = originalQuery;
        this.parentFilter = previousInstance.parentFilter;
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new IncludeNestedDocsWeight(this.parentQuery, this.parentQuery.createWeight(searcher), this.parentFilter);
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.parentQuery.extractTerms(terms);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query parentRewrite = this.parentQuery.rewrite(reader);
        if (parentRewrite != this.parentQuery) {
            return new IncludeNestedDocsQuery(parentRewrite, this.parentQuery, this);
        }
        return this;
    }

    @Override
    public String toString(String field2) {
        return "IncludeNestedDocsQuery (" + this.parentQuery.toString() + ")";
    }

    @Override
    public boolean equals(Object _other) {
        if (_other instanceof IncludeNestedDocsQuery) {
            IncludeNestedDocsQuery other = (IncludeNestedDocsQuery)_other;
            return this.origParentQuery.equals(other.origParentQuery) && this.parentFilter.equals(other.parentFilter);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hash2 = 1;
        hash2 = 31 * hash2 + this.origParentQuery.hashCode();
        hash2 = 31 * hash2 + this.parentFilter.hashCode();
        return hash2;
    }

    @Override
    public Object clone() {
        Query clonedQuery = (Query)this.origParentQuery.clone();
        return new IncludeNestedDocsQuery(clonedQuery, this);
    }

    static class IncludeNestedDocsScorer
    extends Scorer {
        final Scorer parentScorer;
        final FixedBitSet parentBits;
        int currentChildPointer = -1;
        int currentParentPointer = -1;
        int currentDoc = -1;

        IncludeNestedDocsScorer(Weight weight, Scorer parentScorer, FixedBitSet parentBits, int currentParentPointer) {
            super(weight);
            this.parentScorer = parentScorer;
            this.parentBits = parentBits;
            this.currentParentPointer = currentParentPointer;
            if (currentParentPointer == 0) {
                this.currentChildPointer = 0;
            } else {
                this.currentChildPointer = parentBits.prevSetBit(currentParentPointer - 1);
                this.currentChildPointer = this.currentChildPointer == -1 ? 0 : ++this.currentChildPointer;
            }
            this.currentDoc = this.currentChildPointer;
        }

        @Override
        public void visitSubScorers(Query parent, BooleanClause.Occur relationship, Scorer.ScorerVisitor<Query, Query, Scorer> visitor) {
            super.visitSubScorers(parent, relationship, visitor);
            this.parentScorer.visitScorers(visitor);
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.currentParentPointer == Integer.MAX_VALUE) {
                this.currentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (this.currentChildPointer == this.currentParentPointer) {
                this.currentDoc = this.currentParentPointer;
                this.currentParentPointer = this.parentScorer.nextDoc();
                if (this.currentParentPointer != Integer.MAX_VALUE) {
                    this.currentChildPointer = this.parentBits.prevSetBit(this.currentParentPointer - 1);
                    this.currentChildPointer = this.currentChildPointer == -1 ? this.currentParentPointer : ++this.currentChildPointer;
                }
            } else {
                this.currentDoc = this.currentChildPointer++;
            }
            assert (this.currentDoc != -1);
            return this.currentDoc;
        }

        @Override
        public int advance(int target) throws IOException {
            if (target == Integer.MAX_VALUE) {
                this.currentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (target == 0) {
                return this.nextDoc();
            }
            if (target < this.currentParentPointer) {
                this.currentDoc = this.currentParentPointer = this.parentScorer.advance(target);
                if (this.currentParentPointer == Integer.MAX_VALUE) {
                    this.currentDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                if (this.currentParentPointer == 0) {
                    this.currentChildPointer = 0;
                } else {
                    this.currentChildPointer = this.parentBits.prevSetBit(this.currentParentPointer - 1);
                    this.currentChildPointer = this.currentChildPointer == -1 ? 0 : ++this.currentChildPointer;
                }
            } else {
                this.currentDoc = this.currentChildPointer++;
            }
            return this.currentDoc;
        }

        @Override
        public float score() throws IOException {
            return this.parentScorer.score();
        }

        @Override
        public int docID() {
            return this.currentDoc;
        }
    }

    static class IncludeNestedDocsWeight
    extends Weight {
        private final Query parentQuery;
        private final Weight parentWeight;
        private final Filter parentsFilter;

        IncludeNestedDocsWeight(Query parentQuery, Weight parentWeight, Filter parentsFilter) {
            this.parentQuery = parentQuery;
            this.parentWeight = parentWeight;
            this.parentsFilter = parentsFilter;
        }

        @Override
        public Query getQuery() {
            return this.parentQuery;
        }

        @Override
        public float getValue() {
            return this.parentWeight.getValue();
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            return this.parentWeight.sumOfSquaredWeights() * this.parentQuery.getBoost() * this.parentQuery.getBoost();
        }

        @Override
        public void normalize(float norm) {
            this.parentWeight.normalize(norm * this.parentQuery.getBoost());
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer parentScorer = this.parentWeight.scorer(reader, true, false);
            if (parentScorer == null) {
                return null;
            }
            DocIdSet parents = this.parentsFilter.getDocIdSet(reader);
            if (parents == null) {
                return null;
            }
            if (parents instanceof FixedBitDocSet) {
                parents = ((FixedBitDocSet)parents).set();
            }
            if (!(parents instanceof FixedBitSet)) {
                throw new IllegalStateException("parentFilter must return FixedBitSet; got " + parents);
            }
            int firstParentDoc = parentScorer.nextDoc();
            if (firstParentDoc == Integer.MAX_VALUE) {
                return null;
            }
            return new IncludeNestedDocsScorer(this, parentScorer, (FixedBitSet)parents, firstParentDoc);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return null;
        }

        @Override
        public boolean scoresDocsOutOfOrder() {
            return false;
        }
    }
}

