/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.settings;

import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;

public class IndexSettingsService
extends AbstractIndexComponent {
    private volatile Settings settings;
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();

    @Inject
    public IndexSettingsService(Index index2, Settings settings) {
        super(index2, settings);
        this.settings = settings;
    }

    public synchronized void refreshSettings(Settings settings) {
        if (this.settings.getByPrefix("index.").getAsMap().equals(settings.getByPrefix("index.").getAsMap())) {
            return;
        }
        this.settings = ImmutableSettings.settingsBuilder().put(this.settings).put(settings).build();
        for (Listener listener : this.listeners) {
            try {
                listener.onRefreshSettings(settings);
            }
            catch (Exception e) {
                this.logger.warn("failed to refresh settings for [{}]", e, listener);
            }
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public static interface Listener {
        public void onRefreshSettings(Settings var1);
    }
}

