/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.index.Term;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShardComponent;
import org.elasticsearch.index.translog.TranslogException;

public interface Translog
extends IndexShardComponent {
    public static final String TRANSLOG_ID_KEY = "translog_id";

    public long currentId();

    public int estimatedNumberOfOperations();

    public long memorySizeInBytes();

    public long translogSizeInBytes();

    public void newTranslog(long var1) throws TranslogException;

    public void newTransientTranslog(long var1) throws TranslogException;

    public void makeTransientCurrent();

    public void revertTransient();

    public Location add(Operation var1) throws TranslogException;

    public byte[] read(Location var1);

    public Snapshot snapshot() throws TranslogException;

    public Snapshot snapshot(Snapshot var1);

    public void clearUnreferenced();

    public void sync();

    public boolean syncNeeded();

    public void syncOnEachOperation(boolean var1);

    public void close(boolean var1);

    public static class DeleteByQuery
    implements Operation {
        private BytesReference source;
        @Nullable
        private String[] filteringAliases;
        private String[] types = Strings.EMPTY_ARRAY;

        public DeleteByQuery() {
        }

        public DeleteByQuery(Engine.DeleteByQuery deleteByQuery) {
            this(deleteByQuery.source(), deleteByQuery.filteringAliases(), deleteByQuery.types());
        }

        public DeleteByQuery(BytesReference source2, String[] filteringAliases, String ... types) {
            this.source = source2;
            this.types = types == null ? Strings.EMPTY_ARRAY : types;
            this.filteringAliases = filteringAliases;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.DELETE_BY_QUERY;
        }

        @Override
        public long estimateSize() {
            return this.source.length() + 8;
        }

        public BytesReference source() {
            return this.source;
        }

        public String[] filteringAliases() {
            return this.filteringAliases;
        }

        public String[] types() {
            return this.types;
        }

        @Override
        public Source readSource(StreamInput in) throws IOException {
            throw new ElasticSearchIllegalStateException("trying to read doc source from delete_by_query operation");
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int aliasesSize;
            int typesSize;
            int version = in.readVInt();
            this.source = in.readBytesReference();
            if (version < 2 && in.readBoolean()) {
                in.readUTF();
            }
            if ((typesSize = in.readVInt()) > 0) {
                this.types = new String[typesSize];
                for (int i2 = 0; i2 < typesSize; ++i2) {
                    this.types[i2] = in.readUTF();
                }
            }
            if (version >= 1 && (aliasesSize = in.readVInt()) > 0) {
                this.filteringAliases = new String[aliasesSize];
                for (int i3 = 0; i3 < aliasesSize; ++i3) {
                    this.filteringAliases[i3] = in.readUTF();
                }
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(2);
            out.writeBytesReference(this.source);
            out.writeVInt(this.types.length);
            for (String type2 : this.types) {
                out.writeUTF(type2);
            }
            if (this.filteringAliases != null) {
                out.writeVInt(this.filteringAliases.length);
                for (String alias2 : this.filteringAliases) {
                    out.writeUTF(alias2);
                }
            } else {
                out.writeVInt(0);
            }
        }
    }

    public static class Delete
    implements Operation {
        private Term uid;
        private long version;

        public Delete() {
        }

        public Delete(Engine.Delete delete2) {
            this(delete2.uid());
            this.version = delete2.version();
        }

        public Delete(Term uid2) {
            this.uid = uid2;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.DELETE;
        }

        @Override
        public long estimateSize() {
            return (this.uid.field().length() + this.uid.text().length()) * 2 + 20;
        }

        public Term uid() {
            return this.uid;
        }

        public long version() {
            return this.version;
        }

        @Override
        public Source readSource(StreamInput in) throws IOException {
            throw new ElasticSearchIllegalStateException("trying to read doc source from delete operation");
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int version = in.readVInt();
            this.uid = new Term(in.readUTF(), in.readUTF());
            if (version >= 1) {
                this.version = in.readLong();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(1);
            out.writeUTF(this.uid.field());
            out.writeUTF(this.uid.text());
            out.writeLong(this.version);
        }
    }

    public static class Index
    implements Operation {
        private String id;
        private String type;
        private long version;
        private BytesReference source;
        private String routing;
        private String parent;
        private long timestamp;
        private long ttl;

        public Index() {
        }

        public Index(Engine.Index index2) {
            this.id = index2.id();
            this.type = index2.type();
            this.source = index2.source();
            this.routing = index2.routing();
            this.parent = index2.parent();
            this.version = index2.version();
            this.timestamp = index2.timestamp();
            this.ttl = index2.ttl();
        }

        public Index(String type2, String id2, byte[] source2) {
            this.type = type2;
            this.id = id2;
            this.source = new BytesArray(source2);
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.SAVE;
        }

        @Override
        public long estimateSize() {
            return (this.id.length() + this.type.length()) * 2 + this.source.length() + 12;
        }

        public String type() {
            return this.type;
        }

        public String id() {
            return this.id;
        }

        public String routing() {
            return this.routing;
        }

        public String parent() {
            return this.parent;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long ttl() {
            return this.ttl;
        }

        public BytesReference source() {
            return this.source;
        }

        public long version() {
            return this.version;
        }

        @Override
        public Source readSource(StreamInput in) throws IOException {
            this.readFrom(in);
            return new Source(this.source, this.routing, this.parent, this.timestamp, this.ttl);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int version = in.readVInt();
            this.id = in.readUTF();
            this.type = in.readUTF();
            this.source = in.readBytesReference();
            if (version >= 1 && in.readBoolean()) {
                this.routing = in.readUTF();
            }
            if (version >= 2 && in.readBoolean()) {
                this.parent = in.readUTF();
            }
            if (version >= 3) {
                this.version = in.readLong();
            }
            if (version >= 4) {
                this.timestamp = in.readLong();
            }
            if (version >= 5) {
                this.ttl = in.readLong();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(5);
            out.writeUTF(this.id);
            out.writeUTF(this.type);
            out.writeBytesReference(this.source);
            if (this.routing == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.routing);
            }
            if (this.parent == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.parent);
            }
            out.writeLong(this.version);
            out.writeLong(this.timestamp);
            out.writeLong(this.ttl);
        }
    }

    public static class Create
    implements Operation {
        private String id;
        private String type;
        private BytesReference source;
        private String routing;
        private String parent;
        private long timestamp;
        private long ttl;
        private long version;

        public Create() {
        }

        public Create(Engine.Create create2) {
            this.id = create2.id();
            this.type = create2.type();
            this.source = create2.source();
            this.routing = create2.routing();
            this.parent = create2.parent();
            this.timestamp = create2.timestamp();
            this.ttl = create2.ttl();
            this.version = create2.version();
        }

        public Create(String type2, String id2, byte[] source2) {
            this.id = id2;
            this.type = type2;
            this.source = new BytesArray(source2);
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.CREATE;
        }

        @Override
        public long estimateSize() {
            return (this.id.length() + this.type.length()) * 2 + this.source.length() + 12;
        }

        public String id() {
            return this.id;
        }

        public BytesReference source() {
            return this.source;
        }

        public String type() {
            return this.type;
        }

        public String routing() {
            return this.routing;
        }

        public String parent() {
            return this.parent;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long ttl() {
            return this.ttl;
        }

        public long version() {
            return this.version;
        }

        @Override
        public Source readSource(StreamInput in) throws IOException {
            this.readFrom(in);
            return new Source(this.source, this.routing, this.parent, this.timestamp, this.ttl);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int version = in.readVInt();
            this.id = in.readUTF();
            this.type = in.readUTF();
            this.source = in.readBytesReference();
            if (version >= 1 && in.readBoolean()) {
                this.routing = in.readUTF();
            }
            if (version >= 2 && in.readBoolean()) {
                this.parent = in.readUTF();
            }
            if (version >= 3) {
                this.version = in.readLong();
            }
            if (version >= 4) {
                this.timestamp = in.readLong();
            }
            if (version >= 5) {
                this.ttl = in.readLong();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(5);
            out.writeUTF(this.id);
            out.writeUTF(this.type);
            out.writeBytesReference(this.source);
            if (this.routing == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.routing);
            }
            if (this.parent == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.parent);
            }
            out.writeLong(this.version);
            out.writeLong(this.timestamp);
            out.writeLong(this.ttl);
        }
    }

    public static class Source {
        public final BytesReference source;
        public final String routing;
        public final String parent;
        public final long timestamp;
        public final long ttl;

        public Source(BytesReference source2, String routing, String parent, long timestamp, long ttl) {
            this.source = source2;
            this.routing = routing;
            this.parent = parent;
            this.timestamp = timestamp;
            this.ttl = ttl;
        }
    }

    public static interface Operation
    extends Streamable {
        public Type opType();

        public long estimateSize();

        public Source readSource(StreamInput var1) throws IOException;

        public static enum Type {
            CREATE(1),
            SAVE(2),
            DELETE(3),
            DELETE_BY_QUERY(4);

            private final byte id;

            private Type(byte id2) {
                this.id = id2;
            }

            public byte id() {
                return this.id;
            }

            public static Type fromId(byte id2) {
                switch (id2) {
                    case 1: {
                        return CREATE;
                    }
                    case 2: {
                        return SAVE;
                    }
                    case 3: {
                        return DELETE;
                    }
                    case 4: {
                        return DELETE_BY_QUERY;
                    }
                }
                throw new IllegalArgumentException("No type mapped for [" + id2 + "]");
            }
        }
    }

    public static interface Snapshot
    extends Releasable {
        public long translogId();

        public long position();

        public long length();

        public int estimatedTotalOperations();

        public boolean hasNext();

        public Operation next();

        public void seekForward(long var1);

        public InputStream stream() throws IOException;

        public long lengthInBytes();
    }

    public static class Location {
        public final long translogId;
        public final long translogLocation;
        public final int size;

        public Location(long translogId, long translogLocation, int size2) {
            this.translogId = translogId;
            this.translogLocation = translogLocation;
            this.size = size2;
        }
    }
}

