/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.cache.CacheStats;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.indexing.IndexingStats;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.store.StoreStats;

public class NodeIndicesStats
implements Streamable,
Serializable,
ToXContent {
    private StoreStats storeStats;
    private DocsStats docsStats;
    private IndexingStats indexingStats;
    private GetStats getStats;
    private SearchStats searchStats;
    private CacheStats cacheStats;
    private MergeStats mergeStats;
    private RefreshStats refreshStats;
    private FlushStats flushStats;

    NodeIndicesStats() {
    }

    public NodeIndicesStats(StoreStats storeStats, DocsStats docsStats, IndexingStats indexingStats, GetStats getStats, SearchStats searchStats, CacheStats cacheStats, MergeStats mergeStats, RefreshStats refreshStats, FlushStats flushStats) {
        this.storeStats = storeStats;
        this.docsStats = docsStats;
        this.indexingStats = indexingStats;
        this.getStats = getStats;
        this.searchStats = searchStats;
        this.cacheStats = cacheStats;
        this.mergeStats = mergeStats;
        this.refreshStats = refreshStats;
        this.flushStats = flushStats;
    }

    public StoreStats store() {
        return this.storeStats;
    }

    public StoreStats getStore() {
        return this.storeStats;
    }

    public DocsStats docs() {
        return this.docsStats;
    }

    public DocsStats getDocs() {
        return this.docsStats;
    }

    public IndexingStats indexing() {
        return this.indexingStats;
    }

    public IndexingStats getIndexing() {
        return this.indexing();
    }

    public GetStats get() {
        return this.getStats;
    }

    public GetStats getGet() {
        return this.getStats;
    }

    public SearchStats search() {
        return this.searchStats;
    }

    public SearchStats getSearch() {
        return this.searchStats;
    }

    public CacheStats cache() {
        return this.cacheStats;
    }

    public CacheStats getCache() {
        return this.cache();
    }

    public MergeStats merge() {
        return this.mergeStats;
    }

    public MergeStats getMerge() {
        return this.mergeStats;
    }

    public RefreshStats refresh() {
        return this.refreshStats;
    }

    public RefreshStats getRefresh() {
        return this.refresh();
    }

    public FlushStats flush() {
        return this.flushStats;
    }

    public FlushStats getFlush() {
        return this.flushStats;
    }

    public static NodeIndicesStats readIndicesStats(StreamInput in) throws IOException {
        NodeIndicesStats stats = new NodeIndicesStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.storeStats = StoreStats.readStoreStats(in);
        this.docsStats = DocsStats.readDocStats(in);
        this.indexingStats = IndexingStats.readIndexingStats(in);
        this.getStats = GetStats.readGetStats(in);
        this.searchStats = SearchStats.readSearchStats(in);
        this.cacheStats = CacheStats.readCacheStats(in);
        this.mergeStats = MergeStats.readMergeStats(in);
        this.refreshStats = RefreshStats.readRefreshStats(in);
        this.flushStats = FlushStats.readFlushStats(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.storeStats.writeTo(out);
        this.docsStats.writeTo(out);
        this.indexingStats.writeTo(out);
        this.getStats.writeTo(out);
        this.searchStats.writeTo(out);
        this.cacheStats.writeTo(out);
        this.mergeStats.writeTo(out);
        this.refreshStats.writeTo(out);
        this.flushStats.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject(Fields.INDICES);
        this.storeStats.toXContent(builder, params2);
        this.docsStats.toXContent(builder, params2);
        this.indexingStats.toXContent(builder, params2);
        this.getStats.toXContent(builder, params2);
        this.searchStats.toXContent(builder, params2);
        this.cacheStats.toXContent(builder, params2);
        this.mergeStats.toXContent(builder, params2);
        this.refreshStats.toXContent(builder, params2);
        this.flushStats.toXContent(builder, params2);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");

        Fields() {
        }
    }
}

