/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

class RecoveryFilesInfoRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    List<String> phase1FileNames;
    List<Long> phase1FileSizes;
    List<String> phase1ExistingFileNames;
    List<Long> phase1ExistingFileSizes;
    long phase1TotalSize;
    long phase1ExistingTotalSize;

    RecoveryFilesInfoRequest() {
    }

    RecoveryFilesInfoRequest(long recoveryId, ShardId shardId, List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, long phase1TotalSize, long phase1ExistingTotalSize) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.phase1FileNames = phase1FileNames;
        this.phase1FileSizes = phase1FileSizes;
        this.phase1ExistingFileNames = phase1ExistingFileNames;
        this.phase1ExistingFileSizes = phase1ExistingFileSizes;
        this.phase1TotalSize = phase1TotalSize;
        this.phase1ExistingTotalSize = phase1ExistingTotalSize;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i2;
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        int size2 = in.readVInt();
        this.phase1FileNames = new ArrayList<String>(size2);
        for (i2 = 0; i2 < size2; ++i2) {
            this.phase1FileNames.add(in.readString());
        }
        size2 = in.readVInt();
        this.phase1FileSizes = new ArrayList<Long>(size2);
        for (i2 = 0; i2 < size2; ++i2) {
            this.phase1FileSizes.add(in.readVLong());
        }
        size2 = in.readVInt();
        this.phase1ExistingFileNames = new ArrayList<String>(size2);
        for (i2 = 0; i2 < size2; ++i2) {
            this.phase1ExistingFileNames.add(in.readString());
        }
        size2 = in.readVInt();
        this.phase1ExistingFileSizes = new ArrayList<Long>(size2);
        for (i2 = 0; i2 < size2; ++i2) {
            this.phase1ExistingFileSizes.add(in.readVLong());
        }
        this.phase1TotalSize = in.readVLong();
        this.phase1ExistingTotalSize = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeVInt(this.phase1FileNames.size());
        for (String phase1FileName : this.phase1FileNames) {
            out.writeString(phase1FileName);
        }
        out.writeVInt(this.phase1FileSizes.size());
        for (Long phase1FileSize : this.phase1FileSizes) {
            out.writeVLong(phase1FileSize);
        }
        out.writeVInt(this.phase1ExistingFileNames.size());
        for (String phase1ExistingFileName : this.phase1ExistingFileNames) {
            out.writeString(phase1ExistingFileName);
        }
        out.writeVInt(this.phase1ExistingFileSizes.size());
        for (Long phase1ExistingFileSize : this.phase1ExistingFileSizes) {
            out.writeVLong(phase1ExistingFileSize);
        }
        out.writeVLong(this.phase1TotalSize);
        out.writeVLong(this.phase1ExistingTotalSize);
    }
}

