/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.jmx.JmxConnectorCreationException;
import org.elasticsearch.jmx.JmxRegistrationException;
import org.elasticsearch.jmx.ResourceDMBean;

public class JmxService {
    public static final String JMXRMI_URI_PATTERN = "service:jmx:rmi:///jndi/rmi://:{jmx.port}/jmxrmi";
    public static final String JMXRMI_PUBLISH_URI_PATTERN = "service:jmx:rmi:///jndi/rmi://{jmx.host}:{jmx.port}/jmxrmi";
    private final ESLogger logger;
    private final Settings settings;
    private final String jmxDomain;
    private String serviceUrl;
    private String publishUrl;
    private final MBeanServer mBeanServer;
    private JMXConnectorServer connectorServer;
    private final CopyOnWriteArrayList<ResourceDMBean> constructionMBeans = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ResourceDMBean> registeredMBeans = new CopyOnWriteArrayList();
    private String nodeDescription;
    private volatile boolean started = false;

    public static boolean shouldExport(Settings settings) {
        return settings.getAsBoolean("jmx.create_connector", false) != false || settings.getAsBoolean("jmx.export", false) != false;
    }

    public JmxService(ESLogger logger, Settings settings) {
        this.logger = logger;
        this.settings = settings;
        this.jmxDomain = settings.get("jmx.domain", "org.elasticsearch");
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    public String serviceUrl() {
        return this.serviceUrl;
    }

    public String publishUrl() {
        return this.publishUrl;
    }

    public void connectAndRegister(String nodeDescription, final NetworkService networkService) {
        if (this.started) {
            return;
        }
        this.started = true;
        this.nodeDescription = nodeDescription;
        if (this.settings.getAsBoolean("jmx.create_connector", false).booleanValue()) {
            try {
                if (System.getProperty("sun.rmi.dgc.client.gcInterval") == null) {
                    System.setProperty("sun.rmi.dgc.client.gcInterval", "36000000");
                }
                if (System.getProperty("sun.rmi.dgc.server.gcInterval") == null) {
                    System.setProperty("sun.rmi.dgc.server.gcInterval", "36000000");
                }
            }
            catch (Exception secExc) {
                this.logger.warn("Failed to set sun.rmi.dgc.xxx system properties", secExc, new Object[0]);
            }
            String port = this.settings.get("jmx.port", "9400-9500");
            PortsRange portsRange = new PortsRange(port);
            final AtomicReference lastException = new AtomicReference();
            boolean success2 = portsRange.iterate(new PortsRange.PortCallback(){

                @Override
                public boolean onPortNumber(int portNumber) {
                    try {
                        LocateRegistry.createRegistry(portNumber);
                        JmxService.this.serviceUrl = JmxService.this.settings.get("jmx.service_url", JmxService.JMXRMI_URI_PATTERN).replace("{jmx.port}", Integer.toString(portNumber));
                        JMXServiceURL url = new JMXServiceURL(JmxService.this.serviceUrl);
                        JmxService.this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, JmxService.this.settings.getAsMap(), JmxService.this.mBeanServer);
                        JmxService.this.connectorServer.start();
                        String publishHost = networkService.resolvePublishHostAddress(JmxService.this.settings.get("jmx.publish_host")).getHostAddress();
                        JmxService.this.publishUrl = JmxService.this.settings.get("jmx.publish_url", JmxService.JMXRMI_PUBLISH_URI_PATTERN).replace("{jmx.port}", Integer.toString(portNumber)).replace("{jmx.host}", publishHost);
                    }
                    catch (Exception e) {
                        lastException.set(e);
                        return false;
                    }
                    return true;
                }
            });
            if (!success2) {
                throw new JmxConnectorCreationException("Failed to bind to [" + port + "]", (Throwable)lastException.get());
            }
            this.logger.info("bound_address {{}}, publish_address {{}}", this.serviceUrl, this.publishUrl);
        }
        for (ResourceDMBean resource2 : this.constructionMBeans) {
            this.register(resource2);
        }
    }

    public void registerMBean(Object instance) {
        ResourceDMBean resourceDMBean = new ResourceDMBean(instance, this.logger);
        if (!resourceDMBean.isManagedResource()) {
            return;
        }
        if (!this.started) {
            this.constructionMBeans.add(resourceDMBean);
            return;
        }
        this.register(resourceDMBean);
    }

    public void unregisterGroup(String groupName) {
        for (ResourceDMBean resource2 : this.registeredMBeans) {
            if (!groupName.equals(resource2.getGroupName())) continue;
            this.registeredMBeans.remove(resource2);
            String resourceName = resource2.getFullObjectName();
            try {
                ObjectName objectName = new ObjectName(this.getObjectName(resourceName));
                if (!this.mBeanServer.isRegistered(objectName)) continue;
                this.mBeanServer.unregisterMBean(objectName);
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("Unregistered " + objectName, new Object[0]);
            }
            catch (Exception e) {
                this.logger.warn("Failed to unregister " + resource2.getFullObjectName(), new Object[0]);
            }
        }
    }

    public void close() {
        if (!this.started) {
            return;
        }
        this.started = false;
        for (ResourceDMBean resource2 : this.registeredMBeans) {
            String resourceName = resource2.getFullObjectName();
            try {
                ObjectName objectName = new ObjectName(this.getObjectName(resourceName));
                if (!this.mBeanServer.isRegistered(objectName)) continue;
                this.mBeanServer.unregisterMBean(objectName);
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("Unregistered " + objectName, new Object[0]);
            }
            catch (Exception e) {
                this.logger.warn("Failed to unregister " + resource2.getFullObjectName(), new Object[0]);
            }
        }
        if (this.connectorServer != null) {
            try {
                this.connectorServer.stop();
            }
            catch (IOException e) {
                this.logger.debug("Failed to close connector", e, new Object[0]);
            }
        }
    }

    private void register(ResourceDMBean resourceDMBean) throws JmxRegistrationException {
        block6: {
            try {
                String resourceName = resourceDMBean.getFullObjectName();
                ObjectName objectName = new ObjectName(this.getObjectName(resourceName));
                if (!this.mBeanServer.isRegistered(objectName)) {
                    try {
                        this.mBeanServer.registerMBean(resourceDMBean, objectName);
                        this.registeredMBeans.add(resourceDMBean);
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("Registered " + resourceDMBean + " under " + objectName, new Object[0]);
                        }
                        break block6;
                    }
                    catch (InstanceAlreadyExistsException e) {
                        this.logger.debug("Could not register object with name:" + objectName + "(" + e.getMessage() + ")", new Object[0]);
                    }
                    break block6;
                }
                this.logger.debug("Could not register object with name: " + objectName + ", already registered", new Object[0]);
            }
            catch (Exception e) {
                this.logger.warn("Could not register object with name: " + resourceDMBean.getFullObjectName() + "(" + e.getMessage() + ")", new Object[0]);
            }
        }
    }

    private String getObjectName(String resourceName) {
        return this.getObjectName(this.jmxDomain, resourceName);
    }

    private String getObjectName(String jmxDomain, String resourceName) {
        return jmxDomain + ":" + resourceName;
    }

    public static class SettingsConstants {
        public static final String EXPORT = "jmx.export";
        public static final String CREATE_CONNECTOR = "jmx.create_connector";
    }
}

