/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.http.client.HttpDownloadHelper;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.internal.InternalSettingsPerparer;

public class PluginManager {
    private final Environment environment;
    private String url;

    public PluginManager(Environment environment, String url) {
        this.environment = environment;
        this.url = url;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadAndExtract(String name2, boolean verbose) throws IOException {
        String filterZipName;
        boolean downloaded;
        File pluginFile;
        block48: {
            HttpDownloadHelper downloadHelper;
            block44: {
                downloadHelper = new HttpDownloadHelper();
                if (!this.environment.pluginsFile().canWrite()) {
                    System.out.println();
                    throw new IOException("plugin directory " + this.environment.pluginsFile() + " is read only");
                }
                pluginFile = new File(this.environment.pluginsFile(), name2 + ".zip");
                downloaded = false;
                if (this.url != null) {
                    URL pluginUrl = new URL(this.url);
                    System.out.println("Trying " + pluginUrl.toExternalForm() + "...");
                    try {
                        downloadHelper.download(pluginUrl, pluginFile, new HttpDownloadHelper.VerboseProgress(System.out));
                        downloaded = true;
                    }
                    catch (IOException e) {
                        if (!verbose) break block44;
                        System.out.println("Failed: " + ExceptionsHelper.detailedMessage(e));
                    }
                }
            }
            filterZipName = null;
            if (!downloaded && name2.indexOf(47) != -1) {
                URL pluginUrl;
                String[] elements = name2.split("/");
                String userName = elements[0];
                String repoName = elements[1];
                String version = null;
                if (elements.length > 2) {
                    version = elements[2];
                }
                filterZipName = userName + "-" + repoName;
                name2 = repoName;
                if (name2.startsWith("elasticsearch-")) {
                    name2 = name2.substring("elasticsearch-".length());
                } else if (name2.startsWith("es-")) {
                    name2 = name2.substring("es-".length());
                }
                pluginFile = new File(this.environment.pluginsFile(), name2 + ".zip");
                if (version != null) {
                    block47: {
                        block45: {
                            pluginUrl = new URL("http://download.elasticsearch.org/" + userName + "/" + repoName + "/" + repoName + "-" + version + ".zip");
                            System.out.println("Trying " + pluginUrl.toExternalForm() + "...");
                            try {
                                downloadHelper.download(pluginUrl, pluginFile, new HttpDownloadHelper.VerboseProgress(System.out));
                                downloaded = true;
                            }
                            catch (Exception e) {
                                if (!verbose) break block45;
                                System.out.println("Failed: " + ExceptionsHelper.detailedMessage(e));
                            }
                        }
                        if (!downloaded) {
                            block46: {
                                pluginUrl = new URL("http://search.maven.org/remotecontent?filepath=" + userName.replace('.', '/') + "/" + repoName + "/" + version + "/" + repoName + "-" + version + ".zip");
                                System.out.println("Trying " + pluginUrl.toExternalForm() + "...");
                                try {
                                    downloadHelper.download(pluginUrl, pluginFile, new HttpDownloadHelper.VerboseProgress(System.out));
                                    downloaded = true;
                                }
                                catch (Exception e) {
                                    if (!verbose) break block46;
                                    System.out.println("Failed: " + ExceptionsHelper.detailedMessage(e));
                                }
                            }
                            if (!downloaded) {
                                pluginUrl = new URL("https://oss.sonatype.org/service/local/repositories/releases/content/" + userName.replace('.', '/') + "/" + repoName + "/" + version + "/" + repoName + "-" + version + ".zip");
                                System.out.println("Trying " + pluginUrl.toExternalForm() + "...");
                                try {
                                    downloadHelper.download(pluginUrl, pluginFile, new HttpDownloadHelper.VerboseProgress(System.out));
                                    downloaded = true;
                                }
                                catch (Exception e) {
                                    if (!verbose) break block47;
                                    System.out.println("Failed: " + ExceptionsHelper.detailedMessage(e));
                                }
                            }
                        }
                    }
                    if (!downloaded) {
                        pluginUrl = new URL("https://github.com/" + userName + "/" + repoName + "/zipball/v" + version);
                        System.out.println("Trying " + pluginUrl.toExternalForm() + "... (assuming site plugin)");
                        try {
                            downloadHelper.download(pluginUrl, pluginFile, new HttpDownloadHelper.VerboseProgress(System.out));
                            downloaded = true;
                        }
                        catch (Exception e1) {
                            if (verbose) {
                                System.out.println("Failed: " + ExceptionsHelper.detailedMessage(e1));
                            }
                        }
                    }
                } else {
                    pluginUrl = new URL("https://github.com/" + userName + "/" + repoName + "/zipball/master");
                    System.out.println("Trying " + pluginUrl.toExternalForm() + "... (assuming site plugin)");
                    try {
                        downloadHelper.download(pluginUrl, pluginFile, new HttpDownloadHelper.VerboseProgress(System.out));
                        downloaded = true;
                    }
                    catch (Exception e2) {
                        if (!verbose) break block48;
                        System.out.println("Failed: " + ExceptionsHelper.detailedMessage(e2));
                    }
                }
            }
        }
        if (!downloaded) {
            throw new IOException("failed to download out of all possible locations..., use -verbose to get detailed information");
        }
        File extractLocation = new File(this.environment.pluginsFile(), name2);
        if (extractLocation.exists()) {
            throw new IOException("plugin directory already exists. To update the plugin, uninstall it first using -remove " + name2 + " command");
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(pluginFile);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if (zipEntry.isDirectory()) continue;
                String zipName = zipEntry.getName().replace('\\', '/');
                if (filterZipName != null && zipName.startsWith(filterZipName)) {
                    zipName = zipName.substring(zipName.indexOf(47));
                }
                File target = new File(extractLocation, zipName);
                FileSystemUtils.mkdirs(target.getParentFile());
                Streams.copy(zipFile.getInputStream(zipEntry), (OutputStream)new FileOutputStream(target));
            }
        }
        catch (Exception e) {
            System.err.println("failed to extract plugin [" + pluginFile + "]: " + ExceptionsHelper.detailedMessage(e));
            return;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
            pluginFile.delete();
        }
        if (FileSystemUtils.hasExtensions(extractLocation, ".java")) {
            System.out.println("Plugin installation assumed to be site plugin, but contains source code, aborting installation...");
            FileSystemUtils.deleteRecursively(extractLocation);
            return;
        }
        File binFile = new File(extractLocation, "bin");
        if (binFile.exists() && binFile.isDirectory()) {
            File toLocation = new File(new File(this.environment.homeFile(), "bin"), name2);
            System.out.println("Found bin, moving to " + toLocation.getAbsolutePath());
            FileSystemUtils.deleteRecursively(toLocation);
            binFile.renameTo(toLocation);
        }
        if (!new File(extractLocation, "_site").exists() && !FileSystemUtils.hasExtensions(extractLocation, ".class", ".jar")) {
            System.out.println("Identified as a _site plugin, moving to _site structure ...");
            File site = new File(extractLocation, "_site");
            File tmpLocation = new File(this.environment.pluginsFile(), name2 + ".tmp");
            extractLocation.renameTo(tmpLocation);
            FileSystemUtils.mkdirs(extractLocation);
            tmpLocation.renameTo(site);
        }
        System.out.println("Installed " + name2);
    }

    public void removePlugin(String name2) throws IOException {
        File binLocation;
        File pluginToDelete = new File(this.environment.pluginsFile(), name2);
        if (pluginToDelete.exists()) {
            FileSystemUtils.deleteRecursively(pluginToDelete, true);
        }
        if ((pluginToDelete = new File(this.environment.pluginsFile(), name2 + ".zip")).exists()) {
            pluginToDelete.delete();
        }
        if ((binLocation = new File(new File(this.environment.homeFile(), "bin"), name2)).exists()) {
            FileSystemUtils.deleteRecursively(binLocation);
        }
    }

    public static void main(String[] args2) {
        Tuple<Settings, Environment> initialSettings = InternalSettingsPerparer.prepareSettings(ImmutableSettings.Builder.EMPTY_SETTINGS, true);
        if (!initialSettings.v2().pluginsFile().exists()) {
            FileSystemUtils.mkdirs(initialSettings.v2().pluginsFile());
        }
        String url = null;
        boolean verbose = false;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if ("url".equals(args2[i2]) || "-url".equals(args2[i2])) {
                url = args2[i2 + 1];
                continue;
            }
            if (!"verbose".equals(args2[i2]) && !"-verbose".equals(args2[i2])) continue;
            verbose = true;
        }
        PluginManager pluginManager = new PluginManager(initialSettings.v2(), url);
        if (args2.length < 1) {
            System.out.println("Usage:");
            System.out.println("    -url     [plugin location]   : Set exact URL to download the plugin from");
            System.out.println("    -install [plugin name]       : Downloads and installs listed plugins");
            System.out.println("    -remove  [plugin name]       : Removes listed plugins");
            System.out.println("    -verbose                     : Prints verbose messages");
        }
        for (int c = 0; c < args2.length; ++c) {
            String pluginName;
            String command = args2[c];
            if (command.equals("install") || command.equals("-install")) {
                pluginName = args2[++c];
                System.out.println("-> Installing " + pluginName + "...");
                try {
                    pluginManager.downloadAndExtract(pluginName, verbose);
                }
                catch (IOException e) {
                    System.out.println("Failed to install " + pluginName + ", reason: " + e.getMessage());
                }
                continue;
            }
            if (command.equals("remove") || command.equals("-remove")) {
                pluginName = args2[++c];
                System.out.println("-> Removing " + pluginName + " ");
                try {
                    pluginManager.removePlugin(pluginName);
                }
                catch (IOException e) {
                    System.out.println("Failed to remove " + pluginName + ", reason: " + e.getMessage());
                }
                continue;
            }
            ++c;
        }
    }
}

