/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.support;

import java.nio.charset.Charset;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.path.PathTrie;

public class RestUtils {
    public static PathTrie.Decoder REST_DECODER = new PathTrie.Decoder(){

        @Override
        public String decode(String value2) {
            return RestUtils.decodeComponent(value2);
        }
    };

    public static boolean isBrowser(@Nullable String userAgent) {
        if (userAgent == null) {
            return false;
        }
        return userAgent.startsWith("Mozilla");
    }

    public static void decodeQueryString(String s2, int fromIndex, Map<String, String> params2) {
        int i2;
        if (fromIndex < 0) {
            return;
        }
        if (fromIndex >= s2.length()) {
            return;
        }
        String name2 = null;
        int pos2 = fromIndex;
        char c = '\u0000';
        for (i2 = fromIndex; i2 < s2.length(); ++i2) {
            c = s2.charAt(i2);
            if (c == '=' && name2 == null) {
                if (pos2 != i2) {
                    name2 = RestUtils.decodeComponent(s2.substring(pos2, i2));
                }
                pos2 = i2 + 1;
                continue;
            }
            if (c != '&') continue;
            if (name2 == null && pos2 != i2) {
                RestUtils.addParam(params2, RestUtils.decodeComponent(s2.substring(pos2, i2)), "");
            } else if (name2 != null) {
                RestUtils.addParam(params2, name2, RestUtils.decodeComponent(s2.substring(pos2, i2)));
                name2 = null;
            }
            pos2 = i2 + 1;
        }
        if (pos2 != i2) {
            if (name2 == null) {
                RestUtils.addParam(params2, RestUtils.decodeComponent(s2.substring(pos2, i2)), "");
            } else {
                RestUtils.addParam(params2, name2, RestUtils.decodeComponent(s2.substring(pos2, i2)));
            }
        } else if (name2 != null) {
            RestUtils.addParam(params2, name2, "");
        }
    }

    private static void addParam(Map<String, String> params2, String name2, String value2) {
        params2.put(name2, value2);
    }

    public static String decodeComponent(String s2) {
        return RestUtils.decodeComponent(s2, Charsets.UTF_8);
    }

    public static String decodeComponent(String s2, Charset charset) {
        if (s2 == null) {
            return "";
        }
        int size2 = s2.length();
        boolean modified = false;
        for (int i2 = 0; i2 < size2; ++i2) {
            char c = s2.charAt(i2);
            switch (c) {
                case '%': {
                    ++i2;
                }
                case '+': {
                    modified = true;
                }
            }
        }
        if (!modified) {
            return s2;
        }
        byte[] buf = new byte[size2];
        int pos2 = 0;
        block9: for (int i3 = 0; i3 < size2; ++i3) {
            char c = s2.charAt(i3);
            switch (c) {
                case '+': {
                    buf[pos2++] = 32;
                    continue block9;
                }
                case '%': {
                    if (i3 == size2 - 1) {
                        throw new IllegalArgumentException("unterminated escape sequence at end of string: " + s2);
                    }
                    if ((c = s2.charAt(++i3)) == '%') {
                        buf[pos2++] = 37;
                        continue block9;
                    }
                    if (i3 == size2 - 1) {
                        throw new IllegalArgumentException("partial escape sequence at end of string: " + s2);
                    }
                    c = RestUtils.decodeHexNibble(c);
                    char c2 = RestUtils.decodeHexNibble(s2.charAt(++i3));
                    if (c == '\uffff' || c2 == '\uffff') {
                        throw new IllegalArgumentException("invalid escape sequence `%" + s2.charAt(i3 - 1) + s2.charAt(i3) + "' at index " + (i3 - 2) + " of: " + s2);
                    }
                    c = (char)(c * 16 + c2);
                }
                default: {
                    buf[pos2++] = (byte)c;
                }
            }
        }
        return new String(buf, 0, pos2, charset);
    }

    private static char decodeHexNibble(char c) {
        if ('0' <= c && c <= '9') {
            return (char)(c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (char)(c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (char)(c - 65 + 10);
        }
        return '\uffff';
    }
}

