/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.cluster;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.river.routing.RiversRouting;

public class RiverClusterState {
    private final long version;
    private final RiversRouting routing;

    public RiverClusterState(long version, RiverClusterState state2) {
        this.version = version;
        this.routing = state2.routing();
    }

    RiverClusterState(long version, RiversRouting routing) {
        this.version = version;
        this.routing = routing;
    }

    public long version() {
        return this.version;
    }

    public RiversRouting routing() {
        return this.routing;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long version = 0L;
        private RiversRouting routing = RiversRouting.EMPTY;

        public Builder state(RiverClusterState state2) {
            this.version = state2.version();
            this.routing = state2.routing();
            return this;
        }

        public Builder routing(RiversRouting.Builder builder) {
            return this.routing(builder.build());
        }

        public Builder routing(RiversRouting routing) {
            this.routing = routing;
            return this;
        }

        public RiverClusterState build() {
            return new RiverClusterState(this.version, this.routing);
        }

        public static RiverClusterState readFrom(StreamInput in) throws IOException {
            Builder builder = new Builder();
            builder.version = in.readVLong();
            builder.routing = RiversRouting.Builder.readFrom(in);
            return builder.build();
        }

        public static void writeTo(RiverClusterState clusterState, StreamOutput out) throws IOException {
            out.writeVLong(clusterState.version);
            RiversRouting.Builder.writeTo(clusterState.routing, out);
        }
    }
}

