/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.trove.ExtTObjectIntHasMap;
import org.elasticsearch.common.trove.iterator.TObjectIntIterator;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;

public class AggregatedDfs
implements Streamable {
    private TObjectIntHashMap<Term> dfMap;
    private long maxDoc;

    private AggregatedDfs() {
    }

    public AggregatedDfs(TObjectIntHashMap<Term> dfMap, long maxDoc) {
        this.dfMap = dfMap;
        this.maxDoc = maxDoc;
    }

    public TObjectIntHashMap<Term> dfMap() {
        return this.dfMap;
    }

    public long maxDoc() {
        return this.maxDoc;
    }

    public static AggregatedDfs readAggregatedDfs(StreamInput in) throws IOException {
        AggregatedDfs result2 = new AggregatedDfs();
        result2.readFrom(in);
        return result2;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size2 = in.readVInt();
        this.dfMap = new ExtTObjectIntHasMap<Term>(size2, 0.5f, -1);
        for (int i2 = 0; i2 < size2; ++i2) {
            this.dfMap.put(new Term(in.readUTF(), in.readUTF()), in.readVInt());
        }
        this.maxDoc = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.dfMap.size());
        TObjectIntIterator<Term> it = this.dfMap.iterator();
        while (it.hasNext()) {
            it.advance();
            out.writeUTF(it.key().field());
            out.writeUTF(it.key().text());
            out.writeVInt(it.value());
        }
        out.writeVLong(this.maxDoc);
    }
}

