/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.filter;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetCollector;
import org.elasticsearch.search.facet.FacetProcessor;
import org.elasticsearch.search.facet.filter.FilterFacet;
import org.elasticsearch.search.facet.filter.FilterFacetCollector;
import org.elasticsearch.search.facet.filter.InternalFilterFacet;
import org.elasticsearch.search.internal.SearchContext;

public class FilterFacetProcessor
extends AbstractComponent
implements FacetProcessor {
    @Inject
    public FilterFacetProcessor(Settings settings) {
        super(settings);
        InternalFilterFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"filter"};
    }

    @Override
    public FacetCollector parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        Filter facetFilter = context.queryParserService().parseInnerFilter(parser);
        return new FilterFacetCollector(facetName, facetFilter, context.filterCache());
    }

    @Override
    public Facet reduce(String name2, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        int count2 = 0;
        for (Facet facet : facets) {
            count2 = (int)((long)count2 + ((FilterFacet)facet).count());
        }
        return new InternalFilterFacet(name2, count2);
    }
}

