/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoPointFieldData;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class ValueGeoDistanceFacetCollector
extends GeoDistanceFacetCollector {
    private final String indexValueFieldName;
    private final FieldDataType valueFieldDataType;

    public ValueGeoDistanceFacetCollector(String facetName, String fieldName, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, GeoDistanceFacet.Entry[] entries2, SearchContext context, String valueFieldName) {
        super(facetName, fieldName, lat, lon, unit, geoDistance, entries2, context);
        MapperService.SmartNameFieldMappers smartMappers = context.smartFieldMappers(valueFieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + valueFieldName + "]");
        }
        this.indexValueFieldName = smartMappers.mapper().names().indexName();
        this.valueFieldDataType = smartMappers.mapper().fieldDataType();
        this.aggregator = new Aggregator(this.fixedSourceDistance, entries2);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        super.doSetNextReader(reader, docBase);
        ((Aggregator)this.aggregator).valueFieldData = (NumericFieldData)this.fieldDataCache.cache(this.valueFieldDataType, reader, this.indexValueFieldName);
    }

    public static class ValueAggregator
    implements NumericFieldData.DoubleValueInDocProc {
        GeoDistanceFacet.Entry entry;

        @Override
        public void onValue(int docId, double value2) {
            ++this.entry.totalCount;
            this.entry.total += value2;
            if (value2 < this.entry.min) {
                this.entry.min = value2;
            }
            if (value2 > this.entry.max) {
                this.entry.max = value2;
            }
        }
    }

    public static class Aggregator
    implements GeoPointFieldData.ValueInDocProc {
        private final GeoDistance.FixedSourceDistance fixedSourceDistance;
        private final GeoDistanceFacet.Entry[] entries;
        NumericFieldData valueFieldData;
        final ValueAggregator valueAggregator = new ValueAggregator();

        public Aggregator(GeoDistance.FixedSourceDistance fixedSourceDistance, GeoDistanceFacet.Entry[] entries2) {
            this.fixedSourceDistance = fixedSourceDistance;
            this.entries = entries2;
        }

        @Override
        public void onValue(int docId, double lat, double lon) {
            double distance = this.fixedSourceDistance.calculate(lat, lon);
            for (GeoDistanceFacet.Entry entry : this.entries) {
                if (entry.foundInDoc || !(distance >= entry.getFrom()) || !(distance < entry.getTo())) continue;
                entry.foundInDoc = true;
                ++entry.count;
                this.valueAggregator.entry = entry;
                this.valueFieldData.forEachValueInDoc(docId, this.valueAggregator);
            }
        }
    }
}

